<?php
/* OOHForms: checkbox
 *
 * Copyright (c) 1998 by Jay Bloodworth
 * This file is modified by Dino Co.,Ltd.
 *
 * $Id: of_checkbox.inc.php,v 1.3 2003/03/13 09:04:36 tumf Exp $
 */

/**
 * OOHForms: checkbox
 *
 *
 * @package Dino_Form
 * @access public 
 */
class of_checkbox extends of_element {

  var $checked;

  // Constructor
  function of_checkbox($a) {
    $this->setup_element($a);
  }

  function self_get($val, $which, &$count) {
    $str = "";
    
    if ($this->multiple) {
      $n = $this->name . "[]";
      $str .= "<input type='checkbox' name='$n' value='";
      $str .= htmlspecialchars($val, ENT_QUOTES);
      $str .= "'";
      if (is_array($this->value)) {
        reset($this->value);
        while (list($k,$v) = each($this->value)) {
          if ($v==$val) {
            $str .= " checked"; 
            break; 
          }
        }
      }
    } else {
      $str .= "<input type='checkbox' name='$this->name'";
      $str .= " value='";
      $str .= htmlspecialchars($this->value, ENT_QUOTES) . "'";
      if ($this->checked) 
        $str .= " checked";
    }
    if ($this->extrahtml) 
      $str .= " $this->extrahtml";
    $str .= ">\n";
    
    $count = 1;
    return $str;
  }

  function self_get_frozen($val, $which, &$count) {
    $str = "";
    
    $x = 0;
    $t="";
    if ($this->multiple) {
      $n = $this->name . "[]";
      if (is_array($this->value)) {
        reset($this->value);
        while (list($k,$v) = each($this->value)) {
          if ($v==$val) {
	    $v = htmlspecialchars($v, ENT_QUOTES, 'SJIS');
	          $x = 1;
            $str .= "<input type='hidden' name='$this->name' value='$v'>\n";
            $t =" bgcolor=#333333";
            break;
          }
        }
      }
    } else {
      if ($this->checked) {
        $x = 1;
        $t = " bgcolor=#333333";
        $str .= "<input type='hidden' name='$this->name'";
        $str .= " value='";
	$str .= htmlspecialchars($this->value, ENT_QUOTES) . "'>";
      }
    }
    //$str .= "<table$t border=1><tr><td>&nbsp</td></tr></table>\n";

    $count = $x;
    if ($count > 0) {
      $str .= "[*] ";
    } else {
      $str .= "[&nbsp;] ";
    }
    return $str;
  }
  
  function self_load_defaults($val) {
    if ($this->multiple)
      $this->value = $val;
    elseif (isset($val) && (!$this->value || $val==$this->value)) 
      $this->checked=1;
    else 
      $this->checked=0;
  }

} // end CHECKBOX

?>
