<?php
/* OOHForms: radio
 * 
 * Copyright (c) 1998 by Jay Bloodworth
 * This file is modified by Dino Co.,Ltd.
 *
 * $Id: of_radio.inc.php,v 1.16 2003/11/13 14:19:59 shota Exp $
 */

/**
 * OOHForms: radio
 *
 *
 * @package Dino_Form
 * @access public
 */

class of_radio extends of_element {

  var $valid_e;

  // Constructor
  function of_radio($a) {
    $this->setup_element($a);
  }

  function self_get($val, $which, &$count) {
    $str = "";
    
    $str .= "<input type='radio' name='$this->name' value='";
    $str .= htmlspecialchars($val, ENT_QUOTES) . "'";
    if ($this->extrahtml) 
      $str .= " $this->extrahtml";
    if ($this->value==$val) 
      $str .= " checked";
    $str .= " />";
    
    $label="";
    if ($this->options) {
      // ٥
      reset($this->options);
      while(list($k,$v)=each($this->options)){
	if($v['value'] == $val){
	  $label = $v['label'];
	}
      }
    }

    if ($label) {
      $str = $str.$label;
    }

    $count = 1;
    return $str;
  }

  function self_get_frozen($val, $which, &$count, $hidden = false) {
    $str = "";
    
    $x = 0;
    $label = "";

    if ($this->value==$val) {
      //
      if ($this->options) {
	// optionsꤵƤ顢٥Τ߽
	reset($this->options);
	while(list($k,$v)=each($this->options)){
	  if($v['value'] == $this->value){
	    $label = $v['label'];
	  }
	}
      } else {
	// (*)  (&nbsp;) 
	$label = "(*)";
      }
      //
      $x = 1;
      $str .= "<input type='hidden' name='$this->name' value='";
      $str .= htmlspecialchars($val, ENT_QUOTES) . "'\n/>";
    } else {
      if ($this->options) {
	$label = "";
      } else {
	$label = "(&nbsp;)";
      }
    }
    if ($hidden) {
      // never output *visible* HTML
    } else {
      $str .= $label;
    }
    
    $count = $x;
    return $str;
  }

  function self_get_js($ndx_array) {
    $str = "";
    if ($this->valid_e) {
      $n = $this->name;
      
      //ɤ褦      
      if(count($ndx_array) == 1){
      	$flags = ($this->icase ? "gi" : "g");
			    $str .= "if (window.RegExp) {\n";
			    $str .= "  var reg = new RegExp(\"$this->valid_regex\",\"$flags\");\n";
			    $str .= "  if (!reg.test(f.elements['${n}'].value)) {\n";
			    $str .= "    alert(\"$this->valid_e\");\n";
			    $str .= "    f.elements['${n}'].focus();\n";
			    $str .= "    return(false);\n";
			    $str .= "  }\n}\n";
      }elseif(count($ndx_array) >= 1){
	
	$str .= "var l = f.elements['${n}'].length;\n";
	$str .= "var radioOK = false;\n";
	$str .= "for (i=0; i<l; i++)";
	$str .= "  alert(f.elements['${n}'][i].checked);\n";
	
	$str .= "  if (f.elements['${n}'][i].checked) {\n";
	$str .= "    radioOK = true;\n";
	$str .= "    break;\n";
	$str .= "  }\n";
      
	$str .= "if (!radioOK) {\n";
	$str .= "  alert(\"$this->valid_e\");\n";
	$str .= "  return(false);\n";
	$str .= "}\n";
	
      }  
    }
    return $str;
  }

  function self_validate($val) {
    if ($this->valid_e && !isset($val)) return $this->valid_e;
    return false;
  }

} // end RADIO

?>
