<?php
/* OOHForms: select
 *
 * Copyright (c) 1998 by Jay Bloodworth
 * This file is modified by Dino Co.,Ltd.
 *
 * $Id: of_select.inc.php,v 1.6 2003/08/24 09:02:09 hanawa Exp $
 */

/**
 * OOHForms: select
 *
 *
 * @package Dino_Form
 * @access public
 */

class of_select extends of_element {

  var $options;
  var $size;
  var $valid_e;

  // Constructor
  function of_select($a) {
    $this->setup_element($a);
    if ($a["type"]=="select multiple") $this->multiple=1;
  }
  
  function self_get($val,$which, &$count) {
    $str = "";
    
    if ($this->multiple) {
      $n = $this->name . "[]";
      $t = "select multiple";
    } else {
      $n = $this->name;
      $t = "select";
    }
    $str .= "<$t name='$n'";
    if ($this->size) 
      $str .= " size='$this->size'";
    if ($this->extrahtml) 
      $str .= " $this->extrahtml";
    $str .= ">";

    reset($this->options);
    while (list($k,$o) = each($this->options)) {
      $str .= "<option";
      if (is_array($o)) {
	$ov = $o["value"];
        $str .= " value='" .  htmlspecialchars($ov, ENT_QUOTES) . "'";
      } else {
	$ov = $o;
      }

      if (!$this->multiple && isset($this->value) && $this->value==$ov)
	$str .= " selected";
      elseif ($this->multiple && is_array($this->value)) {
        reset($this->value);
	while (list($tk,$v) = each($this->value)) {
	    if ($v==$ov) { 
	      $str .= " selected"; break; 
	    }
	}
      }
      $str .= ">" . htmlspecialchars((is_array($o) ? $o["label"] : $o), ENT_QUOTES) . "\n";
    }
    $str .= "</select>";
    
    $count = 1;
    return $str;
  }

  function self_get_frozen($val,$which, &$count, $hidden = false) {
    $str = "";
    
    $x = 0;
    $n = $this->name . ($this->multiple ? "[]" : "");
    $v_array = (is_array($this->value) ? $this->value : array($this->value));

    /*
    $str .= "<table border=1>\n";
    reset($v_array);
    while (list($tk,$tv) = each($v_array)) {
      reset($this->options);
      while (list($k,$v) = each($this->options)) {
        if ((is_array($v) && 
           (($tmp=$v["value"])==$tv || $v["label"]==$tv))
         || ($tmp=$v)==$tv) {
          $x++;
	  $tmp = htmlspecialchars($tmp, ENT_QUOTES);
          $str .= "<input type='hidden' name='$n' value='$tmp'>\n";
          $str .= "<tr><td>" . htmlspecialchars((is_array($v) ? $v["label"] : $v), ENT_QUOTES) . "</td></tr>\n";
        }
      }
    }
    $str .= "</table>\n";
    */

    // not table 
    reset($v_array);
    while (list($tk,$tv) = each($v_array)) {
      reset($this->options);
      while (list($k,$o) = each($this->options)) {
	if (is_array($o)) $ov = $o["value"];
	else $ov = $o;
        if ($ov==$tv) {
          $x++;
	  $ov = htmlspecialchars($ov, ENT_QUOTES);
          $str .= "<input type='hidden' name='$n' value='$ov'\n/>";
	  if ($hidden) {
	    // never output *visible* HTML
	  } else {
	    $str .= htmlspecialchars((is_array($o) ? $o["label"] : $o), ENT_QUOTES) . "\n";
	  }
        }
      }
    }


    $count = $x;
    return $str;
  }

  function self_get_js($ndx_array) {
    $str = "";
    // ??if $ndx_array is empty.... 
    if(!$ndx_array){ return; }

    if (!$this->multiple && $this->valid_e) {
      $n = $this->name;
      $str .= "if (f.elements['${n}'].selectedIndex == 0) {\n";
      $str .= "  alert(\"$this->valid_e\");\n";
      $str .= "  f.elements['${n}'].focus();\n";
      $str .= "  return(false);\n";
      $str .= "}\n";
    }
    return $str;
  }

  function self_validate($val) {
    if (!$this->multiple && $this->valid_e) {
      reset($this->options);
      $o = current($this->options);
      if (is_array($o)) $ov = $o["value"];
      else $ov = $o;
      if ($val==$ov) return $this->valid_e;
    }
    return false;
  }

} // end SELECT

?>
