/*
 * Decompiled with CFR 0.152.
 */
package ikdnet.diload;

import ikdnet.diload.ArgAttribute;
import ikdnet.diload.DefaultTransFormer;
import ikdnet.diload.aop.time.LoggingProperties;
import ikdnet.diload.aop.time.TimeMethodInstaller;
import ikdnet.diload.manage.TargetResourceManager;
import ikdnet.diload.utils.DILoadUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.logging.Logger;
import javassist.CannotCompileException;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;

public class DITransFormer
implements ClassFileTransformer {
    private static Logger logger = DILoadUtils.createLogger(DefaultTransFormer.class);
    private static LoggingProperties loggingProperties;

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> c, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (className.startsWith("java")) {
            return null;
        }
        if (className.startsWith("com.sun")) {
            return null;
        }
        try {
            if (TargetResourceManager.isExitName(className)) {
                ClassPool pool = new ClassPool();
                pool.appendSystemPath();
                pool.appendClassPath((ClassPath)new ClassClassPath(this.getClass()));
                String bin = (String)TargetResourceManager.getArgument().getArgAttribute("bin").getAttribute();
                pool.appendClassPath(bin);
                ArgAttribute arglib = TargetResourceManager.getArgument().getArgAttribute("lib");
                this.registlib(pool, arglib);
                ArgAttribute containerlib = TargetResourceManager.getArgument().getArgAttribute("container.lib");
                this.registlib(pool, containerlib);
                ByteArrayInputStream bis = new ByteArrayInputStream(classfileBuffer);
                CtClass cc = pool.makeClass((InputStream)bis);
                if (DITransFormer.getLoggingProperties().getPackagelist().accept(cc.getPackageName()) && DITransFormer.getLoggingProperties().getClasslist().accept(cc.getName())) {
                    CtMethod[] cm = cc.getDeclaredMethods();
                    int i = 0;
                    while (i < cm.length) {
                        CtMethod ctMethod = cm[i];
                        if (DITransFormer.getLoggingProperties().getMethodlist().accept(ctMethod.getName())) {
                            logger.info("implement the timechecker = [" + cc.getName() + ":" + ctMethod.getName() + "]");
                            TimeMethodInstaller.install(cc, ctMethod.getName(), DITransFormer.getLoggingProperties());
                        }
                        ++i;
                    }
                }
                return cc.toBytecode();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        catch (NotFoundException e) {
            e.printStackTrace();
        }
        catch (CannotCompileException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void registlib(ClassPool pool, ArgAttribute arglib) {
        if (arglib != null) {
            String lib = (String)arglib.getAttribute();
            lib = lib.replace("\\", "");
            try {
                pool.appendClassPath(lib);
                this.registJar(pool, lib);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void registJar(ClassPool pool, String lib) throws Exception {
        File file = new File(lib);
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            int i = 0;
            while (i < files.length) {
                this.registJar(pool, files[i].getPath());
                ++i;
            }
        } else {
            pool.appendClassPath(file.getPath());
        }
    }

    private static LoggingProperties getLoggingProperties() {
        if (loggingProperties == null) {
            loggingProperties = LoggingProperties.getInstance();
        }
        return loggingProperties;
    }
}

