/*
 * Decompiled with CFR 0.152.
 */
package ikdnet.diload;

import ikdnet.diload.exception.IllegalArgumentException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;

public class InstrumentationFactory {
    private static Instrumentation _inst;
    private static ClassFileTransformer agent;
    private static Instrumentation inst;
    private static long mNativeAgent;
    private static Constructor ct;

    public static void setInstrumentation(Instrumentation inst) {
        _inst = inst;
        InstrumentationFactory.createInstrument();
    }

    public static synchronized Instrumentation getInstrumentation() {
        return _inst;
    }

    public static Class[] getLoadedClass() {
        return _inst.getAllLoadedClasses();
    }

    public static void reBuildInstrumentation() {
        try {
            Object obj = ct.newInstance(mNativeAgent, true, true);
            Instrumentation i = (Instrumentation)obj;
            _inst = inst;
            InstrumentationFactory.addTransformer();
            inst = i;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private static void createInstrument() {
        try {
            Class<?> c = Class.forName("sun.instrument.InstrumentationImpl");
            ct = c.getDeclaredConstructor(Long.TYPE, Boolean.TYPE, Boolean.TYPE);
            ct.setAccessible(true);
            Field f = c.getDeclaredField("mNativeAgent");
            f.setAccessible(true);
            mNativeAgent = f.getLong(_inst);
            Object obj = ct.newInstance(mNativeAgent, true, true);
            inst = (Instrumentation)obj;
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static ClassFileTransformer getAgent() {
        return agent;
    }

    public static void setAgent(ClassFileTransformer agent) {
        InstrumentationFactory.agent = agent;
    }

    public static void addTransformer() {
        _inst.addTransformer(agent);
    }
}

