/*
 * Decompiled with CFR 0.152.
 */
package ikdnet.diload;

import ikdnet.diload.ClassByteManager;
import ikdnet.diload.InstrumentationFactory;
import ikdnet.diload.Messages;
import ikdnet.diload.check.CodeChecker;
import ikdnet.diload.utils.DILoadUtils;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.logging.Logger;

public class Redifiner {
    private static int javaversion = -1;
    private static Logger logger = DILoadUtils.createLogger(Redifiner.class);

    public static void redefine(Class<?> cl, String fileName) {
        try {
            boolean compile;
            if (javaversion == -1) {
                javaversion = DILoadUtils.getJavaVersion();
            }
            if (!(compile = CodeChecker.isError(fileName))) {
                Instrumentation inst = InstrumentationFactory.getInstrumentation();
                final byte[] define = DILoadUtils.loadByte(fileName);
                if (javaversion > 6) {
                    ClassFileTransformer ct = new ClassFileTransformer(){

                        @Override
                        public byte[] transform(ClassLoader loader, String clsName, Class<?> classBeingRedefined, ProtectionDomain pd, byte[] classfileBuffer) {
                            return define;
                        }
                    };
                    try {
                        inst.addTransformer(ct);
                        inst.retransformClasses(cl);
                    }
                    finally {
                        if (inst != null) {
                            inst.removeTransformer(ct);
                        }
                    }
                } else {
                    byte[] originalbyte = ClassByteManager.getOriginalClassByte(cl.getName());
                    if (originalbyte == null) {
                        originalbyte = define;
                    }
                    ClassDefinition[] classDefs = new ClassDefinition[]{new ClassDefinition(cl, define)};
                    ClassByteManager.setCurrentClassByte(cl.getName(), define);
                    inst.redefineClasses(classDefs);
                    classDefs = null;
                }
                logger.info(String.valueOf(Messages.getString("ReloaderAgent.1")) + cl.getName());
            }
        }
        catch (UnsupportedOperationException e) {
            System.err.println(String.valueOf(Messages.getString("ReloaderAgent.2")) + Messages.getString("ReloaderAgent.3") + Messages.getString("ReloaderAgent.4"));
            logger.warning(String.valueOf(Messages.getString("ReloaderAgent.1")) + cl.getName());
            InstrumentationFactory.reBuildInstrumentation();
        }
        catch (Exception e) {
            e.printStackTrace();
            InstrumentationFactory.reBuildInstrumentation();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            InstrumentationFactory.reBuildInstrumentation();
        }
    }
}

