/*
 * Decompiled with CFR 0.152.
 */
package ikdnet.diload.utils.tools.editor;

import ikdnet.diload.utils.tools.editor.NoWrapEditorKit;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.plaf.TextUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoManager;

public class JTextPaneArea
extends JTextPane {
    private static final long serialVersionUID = -3677043645414789084L;
    private int columns;
    private int columnWidth;
    private int rowHeight;
    private int rows;
    private UndoManager undoManager = new UndoManager();
    private boolean word = true;
    private boolean wrap = true;

    public JTextPaneArea() {
        this.setEditorKit(new NoWrapEditorKit());
        this.setLineWrap(false);
    }

    public void append(String str) {
        Document doc = this.getDocument();
        if (doc != null) {
            try {
                doc.insertString(doc.getLength(), str, null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJTextArea();
        }
        return this.accessibleContext;
    }

    public int getColumns() {
        return this.columns;
    }

    protected int getColumnWidth() {
        if (this.columnWidth == 0) {
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            this.columnWidth = metrics.charWidth('m');
        }
        return this.columnWidth;
    }

    public int getLineCount() {
        Element map = this.getDocument().getDefaultRootElement();
        return map.getElementCount();
    }

    public int getLineEndOffset(int line) throws BadLocationException {
        int lineCount = this.getLineCount();
        if (line < 0) {
            throw new BadLocationException("Negative line", -1);
        }
        if (line >= lineCount) {
            throw new BadLocationException("No such line", this.getDocument().getLength() + 1);
        }
        Element map = this.getDocument().getDefaultRootElement();
        Element lineElem = map.getElement(line);
        int endOffset = lineElem.getEndOffset();
        return line == lineCount - 1 ? endOffset - 1 : endOffset;
    }

    public int getLineOfOffset(int offset) throws BadLocationException {
        Document doc = this.getDocument();
        if (offset < 0) {
            throw new BadLocationException("Can't translate offset to line", -1);
        }
        if (offset > doc.getLength()) {
            throw new BadLocationException("Can't translate offset to line", doc.getLength() + 1);
        }
        Element map = this.getDocument().getDefaultRootElement();
        return map.getElementIndex(offset);
    }

    public int getLineStartOffset(int line) throws BadLocationException {
        int lineCount = this.getLineCount();
        if (line < 0) {
            throw new BadLocationException("Negative line", -1);
        }
        if (line >= lineCount) {
            throw new BadLocationException("No such line", this.getDocument().getLength() + 1);
        }
        Element map = this.getDocument().getDefaultRootElement();
        Element lineElem = map.getElement(line);
        return lineElem.getStartOffset();
    }

    public boolean getLineWrap() {
        return this.wrap;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension size = super.getPreferredScrollableViewportSize();
        size = size == null ? new Dimension(400, 400) : size;
        Insets insets = this.getInsets();
        size.width = this.columns == 0 ? size.width : this.columns * this.getColumnWidth() + insets.left + insets.right;
        size.height = this.rows == 0 ? size.height : this.rows * this.getRowHeight() + insets.top + insets.bottom;
        return size;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        d = d == null ? new Dimension(400, 400) : d;
        Insets insets = this.getInsets();
        if (this.columns != 0) {
            d.width = Math.max(d.width, this.columns * this.getColumnWidth() + insets.left + insets.right);
        }
        if (this.rows != 0) {
            d.height = Math.max(d.height, this.rows * this.getRowHeight() + insets.top + insets.bottom);
        }
        return d;
    }

    protected int getRowHeight() {
        if (this.rowHeight == 0) {
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            this.rowHeight = metrics.getHeight();
        }
        return this.rowHeight;
    }

    public int getRows() {
        return this.rows;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        Container parent = this.getParent();
        TextUI ui = this.getUI();
        return parent != null ? ui.getPreferredSize((JComponent)this).width <= parent.getSize().width : true;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        switch (orientation) {
            case 1: {
                return this.getRowHeight();
            }
            case 0: {
                return this.getColumnWidth();
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + orientation);
    }

    public int getTabSize() {
        Integer i;
        int size = 8;
        Document doc = this.getDocument();
        if (doc != null && (i = (Integer)doc.getProperty("tabSize")) != null) {
            size = i;
        }
        return size;
    }

    @Override
    public String getUIClassID() {
        return super.getUIClassID();
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public boolean getWrapStyleWord() {
        return this.word;
    }

    public void insert(String str, int pos) {
        Document doc = this.getDocument();
        if (doc != null) {
            try {
                doc.insertString(pos, str, null);
            }
            catch (BadLocationException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    @Override
    protected String paramString() {
        String wrapString = this.wrap ? "true" : "false";
        String wordString = this.word ? "true" : "false";
        return String.valueOf(super.paramString()) + ",colums=" + this.columns + ",columWidth=" + this.columnWidth + ",rows=" + this.rows + ",rowHeight=" + this.rowHeight + ",word=" + wordString + ",wrap=" + wrapString;
    }

    public void replaceRange(String str, int start, int end) {
        if (end < start) {
            throw new IllegalArgumentException("end before start");
        }
        Document doc = this.getDocument();
        if (doc != null) {
            try {
                if (doc instanceof AbstractDocument) {
                    ((AbstractDocument)doc).replace(start, end - start, str, null);
                } else {
                    doc.remove(start, end - start);
                    doc.insertString(start, str, null);
                }
            }
            catch (BadLocationException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    public void setColumns(int columns) {
        int oldVal = this.columns;
        if (columns < 0) {
            throw new IllegalArgumentException("columns less than zero.");
        }
        if (columns != oldVal) {
            this.columns = columns;
            this.invalidate();
        }
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        this.rowHeight = 0;
        this.columnWidth = 0;
    }

    public void setLineWrap(boolean wrap) {
        boolean old = this.wrap;
        this.wrap = wrap;
        this.firePropertyChange("lineWrap", old, wrap);
    }

    public void setRows(int rows) {
        int oldVal = this.rows;
        if (rows < 0) {
            throw new IllegalArgumentException("rows less than zero.");
        }
        if (rows != oldVal) {
            this.rows = rows;
            this.invalidate();
        }
    }

    public void setTabSize(int size) {
        Document doc = this.getDocument();
        if (doc != null) {
            int old = this.getTabSize();
            doc.putProperty("tabSize", new Integer(size));
            this.firePropertyChange("tabSize", old, size);
        }
    }

    public void setUndoManager(UndoManager undoManager) {
        this.undoManager = undoManager;
    }

    public void setWrapStyleWord(boolean word) {
        boolean old = this.word;
        this.word = word;
        this.firePropertyChange("wrapStyleWord", old, word);
    }

    protected class AccessibleJTextArea
    extends JTextComponent.AccessibleJTextComponent {
        private static final long serialVersionUID = 357136065547729919L;

        protected AccessibleJTextArea() {
            super(JTextPaneArea.this);
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet states = super.getAccessibleStateSet();
            states.add(AccessibleState.MULTI_LINE);
            return states;
        }
    }
}

