/*
 * Decompiled with CFR 0.152.
 */
package ikdnet.diload.utils.tools.editor;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public class LineHighlighter {
    private static final String LINE_HIGHLIGHT = "linehilight";
    private static Color col = new Color(235, 255, 255);
    private static final Highlighter.HighlightPainter[] highlightPainter = new Highlighter.HighlightPainter[]{new DefaultHighlighter.DefaultHighlightPainter(Color.YELLOW), new DefaultHighlighter.DefaultHighlightPainter(Color.CYAN)};
    private static final String[] pattern = new String[]{"Diload configuration file.", "version 0.0.1"};
    private static CaretListener caretListener = new CaretListener(){

        @Override
        public void caretUpdate(CaretEvent e) {
            ((JTextComponent)e.getSource()).repaint();
            LineHighlighter.setHighlight((JTextComponent)e.getSource(), pattern);
        }
    };
    private static MouseAdapter mouseListener = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent me) {
            Object obj = ((JTextComponent)me.getSource()).getClientProperty(LineHighlighter.LINE_HIGHLIGHT);
            ((JTextComponent)me.getSource()).getHighlighter().removeHighlight(obj);
            ((JTextComponent)me.getSource()).repaint();
            LineHighlighter.setHighlight((JTextComponent)me.getSource(), pattern);
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            try {
                JTextComponent c = (JTextComponent)me.getSource();
                Object obj = c.getHighlighter().addHighlight(0, 0, painter);
                c.putClientProperty(LineHighlighter.LINE_HIGHLIGHT, obj);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    };
    private static Highlighter.HighlightPainter painter = new Highlighter.HighlightPainter(){

        @Override
        public void paint(Graphics g, int p0, int p1, Shape bounds, JTextComponent c) {
            try {
                if (c.getSelectionStart() == c.getSelectionEnd()) {
                    Rectangle r = c.modelToView(c.getCaretPosition());
                    g.setColor(col);
                    g.fillRect(0, r.y, c.getWidth(), r.height);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    };

    public static void setHighlight(JTextComponent jtc, String[] pattern) {
        LineHighlighter.removeHighlights(jtc);
        try {
            Highlighter hilite = jtc.getHighlighter();
            Document doc = jtc.getDocument();
            String text = doc.getText(0, doc.getLength());
            int i = 0;
            while (i < pattern.length) {
                int pos = 0;
                while ((pos = text.indexOf(pattern[i], pos)) >= 0) {
                    hilite.addHighlight(pos, pos + pattern[i].length(), highlightPainter[i]);
                    pos += pattern[i].length();
                }
                ++i;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public static void removeHighlights(JTextComponent jtc) {
        Highlighter hilite = jtc.getHighlighter();
        Highlighter.Highlight[] hilites = hilite.getHighlights();
        int i = 0;
        while (i < hilites.length) {
            if (hilites[i].getPainter() instanceof DefaultHighlighter.DefaultHighlightPainter) {
                hilite.removeHighlight(hilites[i]);
            }
            ++i;
        }
    }

    public static void install(JTextComponent c) {
        try {
            Object obj = c.getHighlighter().addHighlight(0, 0, painter);
            c.putClientProperty(LINE_HIGHLIGHT, obj);
            c.addCaretListener(caretListener);
            c.addMouseListener(mouseListener);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }
}

