/*
 * Decompiled with CFR 0.152.
 */
package ikdnet.diload.utils.tools.editor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class LineNumber
extends JComponent {
    private static final long serialVersionUID = -1421831550607852999L;
    private static final Color DEFAULT_BACKGROUND = Color.WHITE;
    private static final Color DEFAULT_FOREGROUND = Color.BLUE;
    private static final Font DEFAULT_FONT = new Font("monospaced", 0, 12);
    private static final int HEIGHT = 2146483647;
    private static final int MARGIN = 5;
    private int lineHeight;
    private int fontLineHeight;
    private int currentRowWidth;
    private FontMetrics fontMetrics;

    public LineNumber(JComponent component) {
        if (component == null) {
            this.setBackground(DEFAULT_BACKGROUND);
            this.setForeground(DEFAULT_FOREGROUND);
            this.setFont(DEFAULT_FONT);
        } else {
            this.setBackground(DEFAULT_BACKGROUND);
            this.setForeground(component.getForeground());
            this.setFont(component.getFont());
        }
        this.setPreferredSize(9999);
    }

    public void setPreferredSize(int row) {
        int width = this.fontMetrics.stringWidth(String.valueOf(row));
        if (this.currentRowWidth < width) {
            this.currentRowWidth = width;
            this.setPreferredSize(new Dimension(10 + width, 2146483647));
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.fontMetrics = this.getFontMetrics(this.getFont());
        this.fontLineHeight = this.fontMetrics.getHeight();
    }

    public int getLineHeight() {
        if (this.lineHeight == 0) {
            return this.fontLineHeight;
        }
        return this.lineHeight;
    }

    public void setLineHeight(int lineHeight) {
        if (lineHeight > 0) {
            this.lineHeight = lineHeight;
        }
    }

    public int getStartOffset() {
        return 4;
    }

    @Override
    public void paintComponent(Graphics g) {
        int lineHeight = this.getLineHeight();
        int startOffset = this.getStartOffset();
        Rectangle drawHere = g.getClipBounds();
        g.setColor(this.getBackground());
        g.fillRect(drawHere.x, drawHere.y, drawHere.width, drawHere.height);
        g.setColor(this.getForeground());
        int startLineNumber = drawHere.y / lineHeight + 1;
        int endLineNumber = startLineNumber + drawHere.height / lineHeight;
        int start = drawHere.y / lineHeight * lineHeight + lineHeight - startOffset;
        int i = startLineNumber;
        while (i <= endLineNumber) {
            String lineNumber = String.valueOf(i);
            int width = this.fontMetrics.stringWidth(lineNumber);
            g.drawString(lineNumber, 5 + this.currentRowWidth - width, start);
            start += lineHeight;
            ++i;
        }
        this.setPreferredSize(endLineNumber);
    }
}

