/*
 * Decompiled with CFR 0.152.
 */
package ikdnet.diload.utils.tools.editor;

import ikdnet.diload.utils.DILoadUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class StartUp {
    private static final String TMP_FILE_NAME = "Temp.jar";

    public static void main(String[] args) {
        String temp = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("java.io.tmpdir");
            }
        });
        String sCurrentDir = StartUp.getCurrentdirectoryPath();
        sCurrentDir = DILoadUtils.combinePath(sCurrentDir);
        File in = new File(String.valueOf(sCurrentDir) + "diload.jar");
        File out = new File(String.valueOf(temp) + TMP_FILE_NAME);
        if (!sCurrentDir.equals(temp)) {
            try {
                StartUp.copyFile(in, out);
                new ProcessBuilder("java", "-cp", String.valueOf(temp) + TMP_FILE_NAME, "ikdnet.diload.utils.tools.editor.Editor", sCurrentDir).start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static void copyFile(File in, File out) throws Exception {
        FileChannel src = null;
        AbstractInterruptibleChannel des = null;
        try {
            src = new FileInputStream(in).getChannel();
            des = new FileOutputStream(out).getChannel();
            src.transferTo(0L, src.size(), (WritableByteChannel)((Object)des));
        }
        finally {
            if (src != null) {
                src.close();
            }
            if (des != null) {
                des.close();
            }
        }
    }

    private static String getCurrentdirectoryPath() {
        String sCurrentDirTemp;
        String sCurrentDir = new File(".").getAbsoluteFile().getParent();
        String base = sCurrentDirTemp = DILoadUtils.combinePath(sCurrentDir);
        File in = new File(String.valueOf(sCurrentDirTemp) + "diload.jar");
        if (in.exists()) {
            return sCurrentDir;
        }
        sCurrentDir = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("user.home");
            }
        });
        sCurrentDirTemp = DILoadUtils.combinePath(sCurrentDir);
        in = new File(String.valueOf(sCurrentDirTemp) + "diload.jar");
        if (in.exists()) {
            return sCurrentDir;
        }
        sCurrentDir = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("user.dir");
            }
        });
        sCurrentDirTemp = DILoadUtils.combinePath(sCurrentDir);
        in = new File(String.valueOf(sCurrentDirTemp) + "diload.jar");
        if (in.exists()) {
            return sCurrentDir;
        }
        URL u = ClassLoader.getSystemResource("diload.jar");
        if (u == null) {
            u = Thread.currentThread().getClass().getResource("diload.jar");
        }
        if (u != null && (in = new File(u.getPath())).exists()) {
            return u.getPath();
        }
        sCurrentDirTemp = String.valueOf(base) + "/web/WEB-INF/lib/";
        in = new File(String.valueOf(sCurrentDirTemp) + "diload.jar");
        if (in.exists()) {
            return sCurrentDirTemp;
        }
        sCurrentDirTemp = String.valueOf(base) + "/WebContent/WEB-INF/lib/";
        in = new File(String.valueOf(sCurrentDirTemp) + "diload.jar");
        if (in.exists()) {
            return sCurrentDirTemp;
        }
        sCurrentDirTemp = String.valueOf(base) + "/WEB-INF/lib/";
        in = new File(String.valueOf(sCurrentDirTemp) + "diload.jar");
        if (in.exists()) {
            return sCurrentDirTemp;
        }
        throw new RuntimeException("Not found file [diload.jar]");
    }
}

