/********************************************************************
 *                                                                  *
 * THIS FILE IS PART OF THE aoTuvWriter SOURCE CODE.                *
 * USE, DISTRIBUTION AND REPRODUCTION OF THIS LIBRARY SOURCE IS     *
 * GOVERNED BY A BSD-STYLE SOURCE LICENSE INCLUDED WITH THIS SOURCE *
 * IN 'COPYING'. PLEASE READ THESE TERMS BEFORE DISTRIBUTING.       *
 *                                                                  *
 * THE OggVorbis SOURCE CODE IS (C) COPYRIGHT 1994-2007             *
 * by the Xiph.Org Foundation http://www.xiph.org/                  *
 *                                                                  *
 * THE aoTuv SOURCE CODE IS (C) COPYRIGHT 2003-2008 Aoyumi          *
 * http://www.geocities.jp/aoyoume/aotuv/                           *
 *                                                                  *
 * THE aoTuvWriter SOURCE CODE IS (C) COPYRIGHT 2008 Cocha          *
 * http://sourceforge.jp/projects/directshow/                       *
 *                                                                  *
 ********************************************************************/

#include "aoTuvWriter.h"

// -----------------------------------------------------------------------------------------------------------------------------------
int CaoTuvWriter::GetPinCount()
{  // s̐Ԃ(tB^[͓̓s1)

   if(m_pInputPin == NULL)
      return 0;

   return 1;
}
// -----------------------------------------------------------------------------------------------------------------------------------
CBasePin *CaoTuvWriter::GetPin(int n)
{  // nԖڂ̃s̃|C^Ԃ(tB^[͓̓s1)

   if(n == 0)
      return m_pInputPin;

   return NULL;
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CaoTuvWriter::NonDelegatingQueryInterface(REFIID riid, void ** ppv)
{  // C^[tFCX擾AQƃJEgCNg

   CheckPointer(ppv, E_POINTER);
   CAutoLock lock(&m_Lock);

   if (riid == IID_IFileSinkFilter)
   {
      return GetInterface((IFileSinkFilter *)this, ppv);
   }
   else if (riid == IID_IMediaPosition || riid == IID_IMediaSeeking)
   {
      if (m_pPosition == NULL) 
      {
         HRESULT hr = S_OK;
         m_pPosition = new CPosPassThru(NAME("aoTuvWriter Pass Through"), (IUnknown *) GetOwner(), (HRESULT *) &hr, m_pInputPin);

         if (m_pPosition == NULL) 
            return E_OUTOFMEMORY;

         if (FAILED(hr)) 
         {
            delete m_pPosition;
            m_pPosition = NULL;
            return hr;
         }
      }

      return m_pPosition->NonDelegatingQueryInterface(riid, ppv);
   } 

   return CBaseFilter::NonDelegatingQueryInterface(riid, ppv);
}
// -----------------------------------------------------------------------------------------------------------------------------------
HRESULT CaoTuvWriter::SetVorbisFormat(void *pVorbisFormat)
{  // GR[hݒ

   CheckPointer(pVorbisFormat, E_POINTER);

   if(m_pInputPin->IsConnected() == FALSE)
   {  // ̓sڑĂȂꍇ
      return VFW_E_NOT_CONNECTED;
   }

   return m_pInputPin->SetVorbisFormat((VORBISFORMAT *)pVorbisFormat);
}
// -----------------------------------------------------------------------------------------------------------------------------------
HRESULT CaoTuvWriter::SetVorbisTag(void *pVorbisTag)
{  // TAGݒ

   CheckPointer(pVorbisTag, E_POINTER);

   if(m_pInputPin->IsConnected() == FALSE)
   {  // ̓sڑĂȂꍇ
      return VFW_E_NOT_CONNECTED;
   }

   return m_pInputPin->SetVorbisTag((VORBISTAG *)pVorbisTag);
}
// -----------------------------------------------------------------------------------------------------------------------------------
CaoTuvWriter::CaoTuvWriter(LPUNKNOWN pUnk, HRESULT *phr)
   : CBaseFilter(NAME("aoTuvWriter"), pUnk, &m_Lock, CLSID_aoTuvWriter) , m_pPosition(NULL)
{  // CaoTuvWriter̃RXgN^
   ASSERT(phr);

   // ̓s̍쐬
   m_pInputPin = new CInputPin(this, GetOwner(), &m_Lock, &m_ReceiveLock, phr);
   if (m_pInputPin == NULL)
   {
      if(phr)
         *phr = E_OUTOFMEMORY;

      return;
   }

   if(phr)
      *phr = S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
CaoTuvWriter::~CaoTuvWriter()
{  // CaoTuvWriter̃fRXgN^

   // ̓s̉
   if(m_pInputPin != NULL)
   {
      delete m_pInputPin;
      m_pInputPin = NULL;
   }

   if(m_pPosition != NULL)
   {
      delete m_pPosition;
      m_pPosition = NULL;
   }
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CaoTuvWriter::SetFileName(LPCOLESTR pszFileName,const AM_MEDIA_TYPE *pmt)
{  // o̓t@Cݒ肷

   CheckPointer(pszFileName,E_POINTER);
   if(wcslen(pszFileName) > MAX_PATH)
      return ERROR_FILENAME_EXCED_RANGE;

   // łɃt@C݂ȂAt@C폜
   if(::PathFileExists(pszFileName) != FALSE)
   {
      if(::DeleteFile(pszFileName) == FALSE)
         return E_FAIL; // t@C폜Ɏs
   }

   // t@C쐬ł邩`FbN
   HANDLE hFile = NULL;
   hFile = ::CreateFile(pszFileName, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, (DWORD)0, NULL);
   if(hFile == INVALID_HANDLE_VALUE)
      return E_FAIL; // t@C쐬Ɏs

   ::CloseHandle(hFile);

   // t@Ci[Ă
   lstrcpyW(m_awFileName, pszFileName);
   m_pInputPin->SetFileName(pszFileName);

   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CaoTuvWriter::GetCurFile(LPOLESTR * ppszFileName,AM_MEDIA_TYPE *pmt)
{  // o̓t@C擾

   CheckPointer(ppszFileName, E_POINTER);
   *ppszFileName = NULL;

   if (m_awFileName != NULL) 
   {
      *ppszFileName = (LPOLESTR)
      QzTaskMemAlloc(sizeof(WCHAR) * (1+lstrlenW(m_awFileName)));

        if (*ppszFileName != NULL) 
            lstrcpyW(*ppszFileName, m_awFileName);
   }

   if(pmt != NULL)
   {
      ZeroMemory(pmt, sizeof(*pmt));
      pmt->majortype = MEDIATYPE_NULL;
      pmt->subtype = MEDIASUBTYPE_NULL;
   }

   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
