/********************************************************************
 *                                                                  *
 * THIS FILE IS PART OF THE aoTuvWriter SOURCE CODE.                *
 * USE, DISTRIBUTION AND REPRODUCTION OF THIS LIBRARY SOURCE IS     *
 * GOVERNED BY A BSD-STYLE SOURCE LICENSE INCLUDED WITH THIS SOURCE *
 * IN 'COPYING'. PLEASE READ THESE TERMS BEFORE DISTRIBUTING.       *
 *                                                                  *
 * THE OggVorbis SOURCE CODE IS (C) COPYRIGHT 1994-2007             *
 * by the Xiph.Org Foundation http://www.xiph.org/                  *
 *                                                                  *
 * THE aoTuv SOURCE CODE IS (C) COPYRIGHT 2003-2008 Aoyumi          *
 * http://www.geocities.jp/aoyoume/aotuv/                           *
 *                                                                  *
 * THE aoTuvWriter SOURCE CODE IS (C) COPYRIGHT 2008 Cocha          *
 * http://sourceforge.jp/projects/directshow/                       *
 *                                                                  *
 ********************************************************************/

#include "aoTuvWriter.h"

#include <commctrl.h>
#include "Resource/resource.h"

static int g_anBitrate[14] = { 32, 40, 48, 56, 64, 80, 96, 112, 128, 160, 224, 224, 256, 320};

// ------------------------------------------------------------------------------------------------------------------------
HRESULT CaoTuvProperties::OnConnect(IUnknown *pUnknown)
{  // vpeBy[W쐬ɌĂяo

   CheckPointer(pUnknown, E_POINTER);

   HRESULT hr;

   // IaoTuvInterface̍쐬
   hr = pUnknown->QueryInterface(IID_IaoTuvInterface, (void **)&m_paoTuvInterface);
   if(FAILED(hr))
      return E_NOINTERFACE;

   return S_OK;
}
// ------------------------------------------------------------------------------------------------------------------------
HRESULT CaoTuvProperties::OnActivate(void)
{  // vpeBy[W쐬ɌĂяo

   int i, nCount;
   WCHAR wText[16];

   CheckPointer(m_paoTuvInterface, E_NOINTERFACE);


   nCount = ::SendMessage(::GetDlgItem(m_Dlg, IDC_COMBO_CBR), CB_GETCOUNT, 0, 0);

   if(nCount <= 0)
   {  // IDC_COMBO_CBRCOMBOBOX̏

      for(i=0;i<14;i++)
      {
         ::wsprintf(wText, TEXT("%dkbps"), g_anBitrate[i]);
         ::SendMessage(::GetDlgItem(this->m_Dlg, IDC_COMBO_CBR), CB_ADDSTRING, 0, (LPARAM)wText);
      }
   }


   nCount = ::SendMessage(::GetDlgItem(m_Dlg, IDC_COMBO_VBR), CB_GETCOUNT, 0, 0);

   if(nCount <= 0)
   {  // IDC_COMBO_VBRCOMBOBOX̏
      ::SendMessage(::GetDlgItem(m_Dlg, IDC_COMBO_VBR), CB_ADDSTRING, 0, (LPARAM)TEXT("-0.1@ 48kbps"));
      ::SendMessage(::GetDlgItem(m_Dlg, IDC_COMBO_VBR), CB_ADDSTRING, 0, (LPARAM)TEXT(" 0.0@ 64kbps"));
      ::SendMessage(::GetDlgItem(m_Dlg, IDC_COMBO_VBR), CB_ADDSTRING, 0, (LPARAM)TEXT(" 0.1@ 80kbps"));
      ::SendMessage(::GetDlgItem(m_Dlg, IDC_COMBO_VBR), CB_ADDSTRING, 0, (LPARAM)TEXT(" 0.2@ 96kbps"));
      ::SendMessage(::GetDlgItem(m_Dlg, IDC_COMBO_VBR), CB_ADDSTRING, 0, (LPARAM)TEXT(" 0.3@128kbps"));
      ::SendMessage(::GetDlgItem(m_Dlg, IDC_COMBO_VBR), CB_ADDSTRING, 0, (LPARAM)TEXT(" 0.4@144kbps"));
      ::SendMessage(::GetDlgItem(m_Dlg, IDC_COMBO_VBR), CB_ADDSTRING, 0, (LPARAM)TEXT(" 0.5@160kbps"));
      ::SendMessage(::GetDlgItem(m_Dlg, IDC_COMBO_VBR), CB_ADDSTRING, 0, (LPARAM)TEXT(" 0.6@192kbps"));
      ::SendMessage(::GetDlgItem(m_Dlg, IDC_COMBO_VBR), CB_ADDSTRING, 0, (LPARAM)TEXT(" 0.7@210kbps"));
      ::SendMessage(::GetDlgItem(m_Dlg, IDC_COMBO_VBR), CB_ADDSTRING, 0, (LPARAM)TEXT(" 0.8@240kbps"));
      ::SendMessage(::GetDlgItem(m_Dlg, IDC_COMBO_VBR), CB_ADDSTRING, 0, (LPARAM)TEXT(" 0.9@320kbps"));
      ::SendMessage(::GetDlgItem(m_Dlg, IDC_COMBO_VBR), CB_ADDSTRING, 0, (LPARAM)TEXT(" 1.0@480kbps"));
   }


   // GR[hݒ擾
   VORBISFORMAT vf;
   m_paoTuvInterface->GetVorbisFormat((void *)&vf);

   // WI{^ƃR{{bNX̐ݒ
   if(-0.11f < vf.fQuality && vf.fQuality < 1.01f)
   {  // VBȐꍇ
      m_bCBR = false;
      m_nIndexCBR = 8;
      m_nIndexVBR = (int)( (vf.fQuality + 0.11f) * 10.0f );

      ::CheckRadioButton(m_Dlg, IDC_RADIO_CBR, IDC_RADIO_VBR, IDC_RADIO_VBR);
      ::SendMessage(::GetDlgItem(m_Dlg, IDC_COMBO_VBR), CB_SETCURSEL, (WPARAM)m_nIndexVBR, 0);
      ::SendMessage(::GetDlgItem(m_Dlg, IDC_COMBO_CBR), CB_SETCURSEL, (WPARAM)m_nIndexCBR, 0);
   }
   else
   {  // CBȐꍇ

      m_bCBR = true;
      ::CheckRadioButton(m_Dlg, IDC_RADIO_CBR, IDC_RADIO_VBR, IDC_RADIO_CBR);

      for(i=0;i<14;i++)
      {
         if( (vf.nAvgBitsPerSec / 1000) == g_anBitrate[i] )
         {
            m_nIndexCBR = i;
            ::SendMessage(::GetDlgItem(m_Dlg, IDC_COMBO_CBR), CB_SETCURSEL, (WPARAM)i, 0);
            break;
         }
      }

      m_nIndexVBR = 5;
      ::SendMessage(::GetDlgItem(m_Dlg, IDC_COMBO_VBR), CB_SETCURSEL, (WPARAM)m_nIndexVBR, 0);
   }

   return S_OK;
}
// ------------------------------------------------------------------------------------------------------------------------
BOOL CaoTuvProperties::OnReceiveMessage(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{  // bZ[WvV[W

   switch (uMsg)
   {
   case WM_COMMAND:

      switch(LOWORD(wParam))
      {
      case IDC_COMBO_CBR:
         m_bDirty = TRUE;
         m_nIndexCBR = ::SendMessage(::GetDlgItem(m_Dlg, IDC_COMBO_CBR), CB_GETCURSEL, (WPARAM)0, (LPARAM)0);
         break;
      case IDC_COMBO_VBR:
         m_bDirty = TRUE;
         m_nIndexVBR = ::SendMessage(::GetDlgItem(m_Dlg, IDC_COMBO_VBR), CB_GETCURSEL, (WPARAM)0, (LPARAM)0);
         break;
      case IDC_RADIO_CBR:
         m_bDirty = TRUE;
         m_bCBR = true;
         ::CheckRadioButton(m_Dlg, IDC_RADIO_CBR, IDC_RADIO_VBR, IDC_RADIO_CBR);
         break;
      case IDC_RADIO_VBR:
         m_bDirty = TRUE;
         m_bCBR = false;
         ::CheckRadioButton(m_Dlg, IDC_RADIO_CBR, IDC_RADIO_VBR, IDC_RADIO_VBR);
         break;

      }
   }


   return CBasePropertyPage::OnReceiveMessage(m_Dlg, uMsg, wParam, lParam);
}
// ------------------------------------------------------------------------------------------------------------------------
HRESULT CaoTuvProperties::OnApplyChanges(void)
{  // OK{^ꂽƂɌĂ΂

   if(m_paoTuvInterface != NULL)
   {  // GR[hݒtB^ɑ

      VORBISFORMAT vorbisFormat;

      if(m_bCBR == true)
      {  // CBȐꍇ

         vorbisFormat.fQuality = -1.0f;
         vorbisFormat.nMinBitsPerSec = -1;
         vorbisFormat.nMaxBitsPerSec = -1;
         vorbisFormat.nAvgBitsPerSec = g_anBitrate[m_nIndexCBR] * 1000;
      }
      else
      {  // VBȐꍇ
         vorbisFormat.nMinBitsPerSec = -1;
         vorbisFormat.nMaxBitsPerSec = -1;
         vorbisFormat.nAvgBitsPerSec = -1;
         vorbisFormat.fQuality = (float)(m_nIndexVBR-1) / 10.0f;
      }

      m_paoTuvInterface->SetVorbisFormat((void *)&vorbisFormat);
   }

   return S_OK;
}
// ------------------------------------------------------------------------------------------------------------------------
HRESULT CaoTuvProperties::OnDisconnect(void)
{  // vpeBy[WƂɌĂ΂

   if(m_paoTuvInterface != NULL)
   {
      m_paoTuvInterface->Release();
      m_paoTuvInterface = NULL;
   }

   return S_OK;
}
// ------------------------------------------------------------------------------------------------------------------------
CUnknown * WINAPI CaoTuvProperties::CreateInstance(LPUNKNOWN lpunk, HRESULT *phr)
{
   ASSERT(phr);

   CUnknown *punk = new CaoTuvProperties(lpunk, phr);

   if(punk == NULL)
   {
      if (phr)
         *phr = E_OUTOFMEMORY;
   }

   return punk;
}
// ------------------------------------------------------------------------------------------------------------------------
CaoTuvProperties::CaoTuvProperties(LPUNKNOWN pUnk, HRESULT *phr) :
   CBasePropertyPage(NAME("aoTuvWriter Property Page"), pUnk, IDD_AOTUVPROP, IDS_TITLE)
{  // RXgN^

   InitCommonControls();
   m_paoTuvInterface = NULL;

   m_bCBR = false;
   m_nIndexCBR = 8;
   m_nIndexVBR = 6;
}
// ------------------------------------------------------------------------------------------------------------------------
