/********************************************************************
 *                                                                  *
 * THIS FILE IS PART OF THE FILEWRITERDX SOURCE CODE.               *
 * USE, DISTRIBUTION AND REPRODUCTION OF THIS LIBRARY SOURCE IS     *
 * GOVERNED BY A BSD-STYLE SOURCE LICENSE INCLUDED WITH THIS SOURCE *
 * IN 'COPYING'. PLEASE READ THESE TERMS BEFORE DISTRIBUTING.       *
 *                                                                  *
 * THE FILEWRITERDX SOURCE CODE IS (C) COPYRIGHT 2008 Cocha         *
 * http://sourceforge.jp/projects/directshow/                       *
 *                                                                  *
 ********************************************************************/

#include "FileWriterDX.h"

// ------------------------------------------------------------------------------------------------------------------------
HRESULT CInputPin::WriteWavHeader(void)
{
   // wavwb_t@C̐擪ɏo͂
   BOOL flag;
   DWORD dwWriteSize;
   DWORD dwBuffer;

   flag = ::WriteFile(m_hFile , "RIFF" , 4, &dwWriteSize , NULL);
   if(flag == FALSE) return E_FAIL;

   dwBuffer = 0;
   flag = ::WriteFile(m_hFile , &dwBuffer  , 4, &dwWriteSize , NULL);
   if(flag == FALSE) return E_FAIL;

   flag = ::WriteFile(m_hFile , "WAVE" , 4, &dwWriteSize , NULL);
   if(flag == FALSE) return E_FAIL;

   flag = ::WriteFile(m_hFile , "fmt " , 4 , &dwWriteSize , NULL);
   if(flag == FALSE) return E_FAIL;

   dwBuffer = 16;
   flag = ::WriteFile(m_hFile, &dwBuffer, 4, &dwWriteSize , NULL);
   if(flag == FALSE) return E_FAIL;

   flag = ::WriteFile(m_hFile, &m_InputFormat.wFormatTag, 2, &dwWriteSize , NULL);
   if(flag == FALSE) return S_FALSE;

   flag = ::WriteFile(m_hFile, &m_InputFormat.nChannels, 2, &dwWriteSize , NULL);
   if(flag == FALSE) return S_FALSE;

   flag = ::WriteFile(m_hFile, &m_InputFormat.nSamplesPerSec, 4, &dwWriteSize , NULL);
   if(flag == FALSE) return S_FALSE;

   flag = ::WriteFile(m_hFile, &m_InputFormat.nAvgBytesPerSec, 4, &dwWriteSize , NULL);
   if(flag == FALSE) return S_FALSE;

   flag = ::WriteFile(m_hFile, &m_InputFormat.nBlockAlign, 2, &dwWriteSize , NULL);
   if(flag == FALSE) return S_FALSE;

   flag = ::WriteFile(m_hFile, &m_InputFormat.wBitsPerSample, 2, &dwWriteSize , NULL);
   if(flag == FALSE) return S_FALSE;

   flag = ::WriteFile(m_hFile, "data", 4, &dwWriteSize , NULL);
   if(flag == FALSE) return S_FALSE;

   dwBuffer = 0;
   flag = ::WriteFile(m_hFile , &dwBuffer, 4, &dwWriteSize , NULL);
   if(flag == FALSE) return E_FAIL;

   return S_OK;
}
// ------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CInputPin::Receive(IMediaSample *pSample)
{
   BOOL flag;
   HRESULT hr;
   DWORD dwWritten;

   CheckPointer(pSample, E_POINTER);

   CAutoLock lock(m_pReceiveLock);

   REFERENCE_TIME tStart, tStop;
   pSample->GetTime(&tStart, &tStop);

   BYTE *pbData;
   hr = pSample->GetPointer(&pbData);
   if(FAILED(hr))
      return hr;

   if(m_hFile == NULL)
   {
      // t@C쐬
      m_hFile = ::CreateFile(m_awFileName, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, (DWORD)0, NULL);

      // ̓TCY̏
      m_llInputSize = 0;

      if(m_bUseWavDest == true)
      {  // wav`Ńt@Cɏo͂ȂAwavwb_o͂

         HRESULT hr;

         hr = WriteWavHeader();
         if(FAILED(hr))
            return hr;
      }
   }

   if(m_bUseWavDest == true)
   {  // wav`ŏo͂ȂA̓TCYJEg
      m_llInputSize += pSample->GetActualDataLength();
   }

   // t@Cɏo͂
   flag = ::WriteFile(m_hFile, (PVOID)pbData, (DWORD)pSample->GetActualDataLength(), &dwWritten, NULL);
   if(flag == FALSE)
      return E_FAIL;

   return S_OK;
}
// ------------------------------------------------------------------------------------------------------------------------
HRESULT CInputPin::Stop()
{  // tB^~ꂽꍇɌĂ΂

   CAutoLock cObjectLock(m_pLock);

   if(m_bUseWavDest == true)
   {  // wav`ŏo͂ȂAwavwb_̃t@CTCYƃf[^TCY𐳂C

      BOOL flag;
      DWORD dwWriteSize;

      DWORD dwTotalSize = 36 + (DWORD)m_llInputSize;
      DWORD dwDataPosition = 40;

      ::SetFilePointer(m_hFile, 4, NULL, FILE_BEGIN);
      flag = ::WriteFile(m_hFile , &dwTotalSize, 4, &dwWriteSize , NULL);
      if(flag == FALSE) return E_FAIL;

      ::SetFilePointer(m_hFile, dwDataPosition, NULL, FILE_BEGIN);
      flag = ::WriteFile(m_hFile , &m_llInputSize, 4, &dwWriteSize , NULL);
      if(flag == FALSE) return E_FAIL;
   }

   if(m_hFile != NULL)
   {  // t@C
      ::CloseHandle(m_hFile);
      m_hFile = NULL;
   }

   return S_OK;
}
// ------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CInputPin::EndOfStream(void)
{  // 󂯎f[^ȂꍇɌĂ΂

   CAutoLock lock(m_pReceiveLock);

   if(m_bUseWavDest == true)
   {  // wav`ŏo͂ȂAwavwb_̃t@CTCYƃf[^TCY𐳂C

      BOOL flag;
      DWORD dwWriteSize;

      DWORD dwTotalSize = 36 + (DWORD)m_llInputSize;
      DWORD dwDataPosition = 40;

      ::SetFilePointer(m_hFile, 4, NULL, FILE_BEGIN);
      flag = ::WriteFile(m_hFile , &dwTotalSize, 4, &dwWriteSize , NULL);
      if(flag == FALSE) return E_FAIL;

      ::SetFilePointer(m_hFile, dwDataPosition, NULL, FILE_BEGIN);
      flag = ::WriteFile(m_hFile , &m_llInputSize, 4, &dwWriteSize , NULL);
      if(flag == FALSE) return E_FAIL;
   }

   if(m_hFile != NULL)
   {  // t@C
      ::CloseHandle(m_hFile);
      m_hFile = NULL;
   }

   return CRenderedInputPin::EndOfStream();
}
// ------------------------------------------------------------------------------------------------------------------------
HRESULT CInputPin::CheckMediaType(const CMediaType *pMediaType)
{  // ̓sق̃sƌqɌĂ΂

   if(*pMediaType->Subtype() == MEDIASUBTYPE_PCM || *pMediaType->Subtype() == MEDIASUBTYPE_IEEE_FLOAT)
   {
      if(*pMediaType->FormatType() == FORMAT_WaveFormatEx)
      {  // wav`Ńt@CɏoꍇAtH[}bg擾Ă
         m_bUseWavDest = true;
         ::CopyMemory(&m_InputFormat, (WAVEFORMATEX *)pMediaType->Format(), sizeof(WAVEFORMATEX));
      }
   }

   // ǂȃsł󂯕t
   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
HRESULT CInputPin::BreakConnect()
{
   if(m_pFilter->m_pPosition != NULL)
      m_pFilter->m_pPosition->ForceRefresh();

   return CRenderedInputPin::BreakConnect();
}
// -----------------------------------------------------------------------------------------------------------------------------------
HRESULT CInputPin::SetFileName(LPCOLESTR pszFileName)
{
   // t@Ci[Ă
   lstrcpyW(m_awFileName, pszFileName);

   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
CInputPin::CInputPin(CFileWriterDX *pFilter, LPUNKNOWN pUnk, CCritSec *pLock, CCritSec *pReceiveLock, HRESULT *phr)
   : CRenderedInputPin(NAME("Input"), pFilter, pLock, phr, L"Input"), m_pReceiveLock(pReceiveLock), m_pFilter(pFilter)
{  // CInputPiñRXgN^

   m_hFile = NULL;
   m_bUseWavDest = false;
   m_llInputSize = 0;
}
// ------------------------------------------------------------------------------------------------------------------------
CInputPin::~CInputPin()
{  // CInputPiñfXgN^

   if(m_hFile != NULL)
   {  // ܂t@CĂȂȂAt@C
      ::CloseHandle(m_hFile);
      m_hFile = NULL;
   }
}
// ------------------------------------------------------------------------------------------------------------------------
