/********************************************************************
 *                                                                  *
 * THIS FILE IS PART OF THE MP3FRAUNHOFERENC SOURCE CODE.           *
 * USE, DISTRIBUTION AND REPRODUCTION OF THIS LIBRARY SOURCE IS     *
 * GOVERNED BY A BSD-STYLE SOURCE LICENSE INCLUDED WITH THIS SOURCE *
 * IN 'COPYING'. PLEASE READ THESE TERMS BEFORE DISTRIBUTING.       *
 *                                                                  *
 * THE MP3FRAUNHOFERENC SOURCE CODE IS (C) COPYRIGHT 2008 Cocha     *
 * http://sourceforge.jp/projects/directshow/                       *
 *                                                                  *
 ********************************************************************/

#ifndef __MP3FraunhoferEnc_h__
#define __MP3FraunhoferEnc_h__

typedef struct mpeglayer3waveformat_tag
{
  WAVEFORMATEX wfx;
  WORD wID;
  DWORD fdwFlags;
  WORD nBlockSize;
  WORD nFramesPerBlock;
  WORD nCodecDelay;
} MPEGLAYER3WAVEFORMAT;

// -----------------------------------------------------------------------------------------------------------------------------------
class CMP3FraunhoferEnc : public CTransformFilter
{
   friend class CAcmFraunhofer;

public:
   DECLARE_IUNKNOWN

   // RXgN^ƃfXgN^
   CMP3FraunhoferEnc(LPUNKNOWN pUnk,HRESULT *phr);
   virtual ~CMP3FraunhoferEnc();

   // IuWFNg쐬֐
   static CUnknown * WINAPI CreateInstance(LPUNKNOWN, HRESULT *);

   // CTransformFilteȑz\bh
   HRESULT CheckInputType(const CMediaType *);
   HRESULT CheckTransform(const CMediaType *,const CMediaType *);
   HRESULT GetMediaType(int iPosition,CMediaType *);
   HRESULT DecideBufferSize(IMemAllocator *, ALLOCATOR_PROPERTIES *);

   // CTransformFilter̃I[o[Ch
   HRESULT StartStreaming(void);
   HRESULT Receive(IMediaSample *);
   HRESULT StopStreaming();
   HRESULT EndOfStream(void);

   // IMP3FraunhoferInterface
   STDMETHODIMP GetInFormat(WAVEFORMATEX *);
   STDMETHODIMP CheckBitrate(int);
   STDMETHODIMP CheckBitrate(WAVEFORMATEX *, int);
   STDMETHODIMP GetBitrate(int *);
   STDMETHODIMP SetBitrate(int);

private:

   // [Uϐ
   bool m_bProfessional;
   int m_nBitrate;
   CCritSec m_myLock;
   CAcmFraunhofer *m_pAcmFraunhofer;

   WAVEFORMATEX m_inFormat;
   MPEGLAYER3WAVEFORMAT m_outFormat;

   int m_nInBufferSize;
   int m_nOutBufferSize;
};

// -----------------------------------------------------------------------------------------------------------------------------------
#endif __MP3FraunhoferEnc_h__
