/********************************************************************
 *                                                                  *
 * THIS FILE IS PART OF THE MP3LAMEWRITER SOURCE CODE.              *
 * USE, DISTRIBUTION AND REPRODUCTION OF THIS LIBRARY SOURCE IS     *
 * GOVERNED BY A BSD-STYLE SOURCE LICENSE INCLUDED WITH THIS SOURCE *
 * IN 'COPYING'. PLEASE READ THESE TERMS BEFORE DISTRIBUTING.       *
 *                                                                  *
 * THE MP3LAMEWRITER SOURCE CODE IS (C) COPYRIGHT 2008 Cocha        *
 * http://sourceforge.jp/projects/directshow/                       *
 *                                                                  *
 ********************************************************************/

#include "MP3LameWriter.h"
#include <commctrl.h>

// ------------------------------------------------------------------------------------------------------------------------
HRESULT CProperties::OnConnect(IUnknown *pUnknown)
{  // vpeBy[W쐬ɌĂяo

   CheckPointer(pUnknown, E_POINTER);

   HRESULT hr;

   // IMP3LameInterface̍쐬
   hr = pUnknown->QueryInterface(IID_IMP3LameInterface, (void **)&m_pMP3LameInterface);
   if(FAILED(hr))
      return E_NOINTERFACE;

   return S_OK;
}
// ------------------------------------------------------------------------------------------------------------------------
HRESULT CProperties::OnActivate(void)
{  // vpeBy[W쐬ɌĂяo

   HRESULT hr;
   int i, nCount;
   WCHAR wText[64];

   CheckPointer(m_pMP3LameInterface, E_NOINTERFACE);

   // IDC_COMBO_CBR̍ڐ擾
   nCount = ::SendMessage(::GetDlgItem(m_Dlg, IDC_COMBO_CBR), CB_GETCOUNT, 0, 0);

   if(nCount <= 0)
   {  // IDC_COMBO_CBȐ

      int anBitrate[14] = { 32, 40, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320};

      for(i=0;i<14;i++)
      {
         ::wsprintf(wText, TEXT("%d kbps"), anBitrate[i]);
         ::SendMessage(::GetDlgItem(this->m_Dlg, IDC_COMBO_CBR), CB_ADDSTRING, 0, (LPARAM)wText);
      }
   }

   // IDC_COMBO_VBR̍ڐ擾
   nCount = ::SendMessage(::GetDlgItem(m_Dlg, IDC_COMBO_VBR), CB_GETCOUNT, 0, 0);

   if(nCount <= 0)
   {  // IDC_COMBO_VBȐ

      for(i=0;i<=9;i++)
      {
         WCHAR awComboText[10][16] = { L"0 (200`240kbps)", L"1 (190`230kbps)", L"2 (170`210kbps)", L"3 (150`180kbps)", L"4 (140`170kbps)",
                                       L"5 (120`150kbps)", L"6 (110`140kbps)", L"7 (100`130kbps)", L"8 (90`120kbps)", L"9 (80`110bps)"};

         ::SendMessage(::GetDlgItem(this->m_Dlg, IDC_COMBO_VBR), CB_ADDSTRING, 0, (LPARAM)awComboText[i]);
      }
   }

   // lamẽo[W\
   HMODULE hDLL = NULL;
   BEVERSION beVersion;
   BE_VERSION ver;

   hDLL = ::LoadLibrary(TEXT("lame_enc.dll"));

   if(hDLL != NULL)
   {
      beVersion = (BEVERSION)::GetProcAddress(hDLL, "beVersion");

      if(beVersion)
      {
         beVersion = (BEVERSION)::GetProcAddress(hDLL, "beVersion");
         beVersion(&ver);

         ::wsprintf(wText, TEXT("lame_enc.dll@ver %d.%d (%d/%02d/%02d)"), ver.byMajorVersion, ver.byMinorVersion, ver.wYear, ver.byMonth, ver.byDay);
         ::SetDlgItemText(this->m_Dlg, IDC_STATIC_VERSION, wText);
      }

      ::FreeLibrary(hDLL);
   }

   // R{{bNẌʒu킹
   LAME_CONFIG lameConfig;
   hr = m_pMP3LameInterface->GetOutFormat(&lameConfig);
   if(hr == S_OK)
   {
      WCHAR wComboText[64];

      ::wsprintf(wText, TEXT("%d kbps"), lameConfig.cbr.dwBitrate);

      for(i=0;i<14;i++)
      {
         ::SendMessage(::GetDlgItem(m_Dlg, IDC_COMBO_CBR), CB_GETLBTEXT, (WPARAM)i, (LPARAM)wComboText);

         if(::lstrcmp(wComboText, wText) == 0)
         {
            ::SendMessage(::GetDlgItem(m_Dlg, IDC_COMBO_CBR), CB_SETCURSEL, (WPARAM)i, (LPARAM)0);
            break;
         }
      }

      ::SendMessage(::GetDlgItem(m_Dlg, IDC_COMBO_VBR), CB_SETCURSEL, (WPARAM)lameConfig.vbr.nVBRQuality, (LPARAM)0);


      if(lameConfig.nMode == MODE_CBR)
         ::CheckRadioButton(m_Dlg, IDC_RADIO_CBR, IDC_RADIO_VBR, IDC_RADIO_CBR);
      else
         ::CheckRadioButton(m_Dlg, IDC_RADIO_CBR, IDC_RADIO_VBR, IDC_RADIO_VBR);
   }


   return S_OK;
}
// ------------------------------------------------------------------------------------------------------------------------
BOOL CProperties::OnReceiveMessage(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{  // bZ[WvV[W

   switch (uMsg)
   {
   case WM_COMMAND:

      switch(LOWORD(wParam))
      {
      case IDC_COMBO_CBR:
         m_bDirty = TRUE;
         break;
      case IDC_COMBO_VBR:
         m_bDirty = TRUE;
         break;
      case IDC_RADIO_CBR:
         ::CheckRadioButton(m_Dlg, IDC_RADIO_CBR, IDC_RADIO_VBR, IDC_RADIO_CBR);
         m_bDirty = TRUE;
         break;
      case IDC_RADIO_VBR:
         ::CheckRadioButton(m_Dlg, IDC_RADIO_CBR, IDC_RADIO_VBR, IDC_RADIO_VBR);
         m_bDirty = TRUE;
         break;
      }
   }


   return CBasePropertyPage::OnReceiveMessage(m_Dlg, uMsg, wParam, lParam);
}
// ------------------------------------------------------------------------------------------------------------------------
HRESULT CProperties::OnApplyChanges(void)
{  // OK{^ꂽƂɌĂ΂

   if(m_pMP3LameInterface != NULL)
   {  // o͐ݒtB^ɑ

      LAME_CONFIG lameConfig;

      ::ZeroMemory(&lameConfig, sizeof(lameConfig));

      if(::IsDlgButtonChecked(m_Dlg, IDC_RADIO_CBR) == 1)
         lameConfig.nMode = MODE_CBR;
      else
         lameConfig.nMode = MODE_VBR;

      int anBitrate[14] = { 32, 40, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320};
      lameConfig.cbr.dwBitrate = anBitrate[::SendMessage(::GetDlgItem(m_Dlg, IDC_COMBO_CBR), CB_GETCURSEL, (WPARAM)0, (LPARAM)0)];
      lameConfig.vbr.nVBRQuality = ::SendMessage(::GetDlgItem(m_Dlg, IDC_COMBO_VBR), CB_GETCURSEL, (WPARAM)0, (LPARAM)0);

      m_pMP3LameInterface->SetOutFormat(&lameConfig);
   }

   return S_OK;
}
// ------------------------------------------------------------------------------------------------------------------------
HRESULT CProperties::OnDisconnect(void)
{  // vpeBy[WƂɌĂ΂

   if(m_pMP3LameInterface != NULL)
   {
      m_pMP3LameInterface->Release();
      m_pMP3LameInterface = NULL;
   }

   return S_OK;
}
// ------------------------------------------------------------------------------------------------------------------------
CUnknown * WINAPI CProperties::CreateInstance(LPUNKNOWN lpunk, HRESULT *phr)
{
   ASSERT(phr);

   CUnknown *punk = new CProperties(lpunk, phr);

   if(punk == NULL)
   {
      if (phr)
         *phr = E_OUTOFMEMORY;
   }

   return punk;
}
// ------------------------------------------------------------------------------------------------------------------------
CProperties::CProperties(LPUNKNOWN pUnk, HRESULT *phr) :
   CBasePropertyPage(NAME("MP3 Lame Writer Property Page"), pUnk, IDD_MP3LAMEPROP, IDS_TITLE)
{  // RXgN^

   InitCommonControls();
   m_pMP3LameInterface = NULL;
}
// ------------------------------------------------------------------------------------------------------------------------
