require 'dip/dip'

class SimpleObserver
  def initialize(server)
    @server = server
    @server.add_observer(self)
  end
  
  def update(event, *arg)
    case event
    when :recv
      do_recv(*arg)
    end
  end
  
  def do_recv(msg)
    puts kconv(">>>>>>>>>>>> From: #{msg.from.addr}")
    puts kconv(msg.message)
    puts "-------------------------------------------------"
  end
  
  def kconv(str)
    return nil if str == nil
    Kconv::toeuc(str.to_s)
  end
end

puts 'phrase: '
phrase = gets.chomp

daemon = DIP::Daemon.new(phrase)
biff = SimpleObserver.new(daemon.server)
uri = ARGV.shift || 'druby://localhost:12345'
DRb.start_service(uri, daemon.front)
daemon.thread.join

