# vim: fileencoding=utf8
from django.conf import settings
import os.path
import amf
import re

def views():
    pass

def save_to_file(data, filename, dir=None):
    """
    Saves the given data to a file, and returns the dict object
    holding path and url keys.

    To use this function, MEDIA_ROOT and MEDIA_URL must be
    set in Django configuration file.
    """
    if isinstance(data, amf.ByteArray):
        data = data.data
    if dir:
        filename = os.path.join(dir, filename)
    path = os.path.join(settings.MEDIA_ROOT, filename)
    file = open(path, 'wb')
    try:
        file.write(data)
    except:
        amf.logger.error("Cannot write data to file.")
        raise
    else:
        file.close()
    url = os.path.join(settings.MEDIA_URL, filename)
    url = re.sub(r'\\', '/', url)
    return { 'path':path, 'url':url }
