import addressbook.Card;

import flash.events.Event;
import flash.events.NetStatusEvent;
import flash.utils.ByteArray;

import mx.collections.ArrayCollection;
import mx.controls.Alert;
import mx.formatters.DateFormatter;
import mx.rpc.AsyncToken;
import mx.rpc.events.FaultEvent;
import mx.rpc.events.ResultEvent;
import mx.utils.ObjectUtil;

import org.seasar.flex2.rpc.remoting.RemoteService;

[Bindable]
private var selectedCard:Card;

private function init():void {
	addressBookService.addEventListener(NetStatusEvent.NET_STATUS, netStatusHandler);
    getCards();
}

 private function netStatusHandler(event:NetStatusEvent):void {
    Alert.show(ObjectUtil.toString(event));
}
        
private function getCards():void {
	addressBookService.method="getCards()";
    var token:AsyncToken = addressBookService.getCards();
    token.resultHandler = onGetCards;
}

private function onGetCards(re:ResultEvent):void {
    //trace(ObjectUtil.toString(re.result));
    var cards:Array = re.result as Array;
    var cardCollection:ArrayCollection = new ArrayCollection(cards);
    listDG.dataProvider = cardCollection;
}

/**
 * Invoked when the 'save' button is clicked.
 */
private function saveCard():void {
    var card:Card = selectedCard ? selectedCard : new Card();
    
    card.birthday = birthdayDF.selectedDate;
    card.portrait = portrait.getByteArrayOfPortrait();
    card.lastName = lastNameTxt.text;
    card.firstName = firstNameTxt.text;
    card.company = companyTxt.text;
    card.tel = telTxt.text;
    card.email = emailTxt.text;
    card.zip = zipTxt.text;
    card.address = addressTA.text;
    card.url = urlTxt.text;
    /*
    if (card.birthday == null) {
    	Alert.show('birthday is null');
    	return;
    }
    */
    var token:AsyncToken = addressBookService.saveCard(card);
    token.resultHandler = onSave;
}

private function onSave(re:ResultEvent):void {
    getCards();
    newCard();
}

/**
 * Invoked when the 'delete' button is clicked.
 */
private function deleteCard():void {
    var token:AsyncToken = addressBookService.deleteCard(selectedCard.id);
    token.resultHandler = onDelete;
}

private function onDelete(re:ResultEvent):void {
    var list:ArrayCollection = ArrayCollection(listDG.dataProvider);
    var index:int = list.getItemIndex(selectedCard);
    if (index != -1) {
        list.removeItemAt(index);
    }
    newCard();
}

/**
 * Invoked when the 'new data' button is clicked.
 */
private function newCard():void {
    selectedCard = null;
    portrait.doErase(true);
    lastNameTxt.text = "";
    firstNameTxt.text = "";
    companyTxt.text = "";
    telTxt.text = "";
    emailTxt.text = "";
    zipTxt.text = "";
    addressTA.text = "";
    urlTxt.text = "";
    birthdayDF.text = "";
    lastNameTxt.setFocus();
}



private function onFault(fe:FaultEvent):void {
    trace(fe.fault.faultDetail);
    Alert.show(fe.fault.faultString);
}

private function showCard(card:Card):void {
    if (!card) {
        return;
    }
    selectedCard = card;
    lastNameTxt.text = card.lastName;
    firstNameTxt.text = card.firstName;
    companyTxt.text = card.company;
    telTxt.text = card.tel;
    emailTxt.text = card.email;
    zipTxt.text = card.zip;
    addressTA.text = card.address;
    urlTxt.text = card.url;
    if (card.birthday != null) {
        var formatter:DateFormatter = new DateFormatter();
        formatter.formatString = "YYYY/MM/DD";
        birthdayDF.text = formatter.format(card.birthday);
    } else {
        birthdayDF.text = "";
    }

    if (card.portraitUrl != null) {
        portrait.showImageOnCanvas(card.portraitUrl);
    } else {
        portrait.doErase(true);
    }
}
