# vim: fileencoding=utf8
from django.db import models

class Card(models.Model):

    lastName      = models.CharField(maxlength=20)
    firstName     = models.CharField(maxlength=20)
    company       = models.CharField(maxlength=50)
    tel           = models.CharField(maxlength=15)
    email         = models.EmailField(null=True)
    zip           = models.CharField(maxlength=8)
    address       = models.CharField(maxlength=200)
    url           = models.CharField(null=True, maxlength=300)
    birthday      = models.DateField(null=True)
    portraitUrl   = models.CharField(null=True, maxlength=300)

    def __init__(self, *row):
        models.Model.__init__(self, *row)
        self.portrait = None

    class Admin:
        pass

