# vim: fileencoding=utf8
import os.path
import re
from types import *
import amf, amf.utils
from django.conf import settings

def views():
    pass

def save_to_file(data, filename, dir=None):
    """
    Saves the given data to a file, and returns the dict object
    holding path and url keys.

    To use this function, MEDIA_ROOT and MEDIA_URL must be
    set in Django configuration file.
    """
    if isinstance(data, amf.ByteArray):
        data = data.data
    if dir:
        filename = os.path.join(dir, filename)
    path = os.path.join(settings.MEDIA_ROOT, filename)
    file = open(path, 'wb')
    try:
        file.write(data)
    except:
        raise
    else:
        file.close()
    url = os.path.join(settings.MEDIA_URL, filename)
    url = re.sub(r'\\', '/', url)
    return { 'path':path, 'url':url }

def delete_file(filename, dir=None):
    """
    Delete the file located in MEDIA_ROOT directory.
    If the operation fails or the target file doesn't exist, return False.
    """
    if dir:
        filename = os.path.join(dir, filename)
    path = os.path.join(settings.MEDIA_ROOT, filename)
    if os.path.exists(path):
        try:
            os.remove(path)
            return True
        except:
            pass
    return False

def __get_user_permissions(request):
    auth_func = getattr(settings, 'AMF_AUTH_FUNC', None)
    if auth_func:
        username = request.amfcredentials.get('username')
        password = request.amfcredentials.get('password')
        if isinstance(auth_func, FunctionType):
            result = auth_func(request, username, password)
        elif isinstance(auth_func, StringTypes):
            f = amf.utils.get_func(auth_func)
            result = f(request, username, password)
        if isinstance(result, (StringTypes, ListType, TupleType)):
            return result
    return ()

def __authenticate(perm, request):
    permissions = perm.split(' ')
    user_permissions = __get_user_permissions(request)
    for p in permissions:
        if p in user_permissions:
            return True
    return False

def permission_required(perm):
    def func_wrapper(func):
        def wrapper(request, *args):
            if __authenticate(perm, request):
                return func(request, *args)
            else:
                func_name = func.__name__
                raise amf.AMFAuthenticationError("The user does not have access to '%s'" % (func_name,))
        return wrapper
    return func_wrapper

