
/*!
@file dkcBuffer.c
@author d
@since 2004/3/xx
*/
#define DKUTIL_C_BUFFER_C
#include "dkcBuffer.h"



///obt@̈𓾂B
DKC_BUFFER* WINAPI dkcAllocBuffer(const void *data,size_t size){
	DKC_BUFFER *p;
	
	if(0==size) return NULL;

	p = (DKC_BUFFER *)dkcAllocate(sizeof(DKC_BUFFER));
	if(NULL==p) return NULL;
	

	p->mBuff = (BYTE *)dkcAllocate(size);
	if(NULL==p->mBuff) goto Error;
	
	p->mSize = size;

	if(data){
		if(DKUTIL_FAILED(dkcBufferSet(p,data,size))){
			goto Error;
		}
	}else{
		
	}
	return p;
Error:
	dkcFree((void **)&p);
	return NULL;
}

int WINAPI dkcFreeBuffer(DKC_BUFFER **ptr){
	if(NULL==ptr || NULL==*ptr) return edk_ArgumentException;
	dkcFree((void **)&(*ptr)->mBuff);
	dkcFree((void **)ptr);
	return edk_SUCCEEDED;
}



int WINAPI dkcBufferSet(DKC_BUFFER *ptr,const void *data,size_t size)
{
	//if(NULL==ptr) return edk_ArgumentException;//

	return dkc_memcpy(ptr->mBuff,ptr->mSize,data,size);
}


int WINAPI dkcBufferSetOffset(DKC_BUFFER *ptr,
															const void *data,size_t size,size_t offset){
	if(ptr->mSize < offset + size){
		return edk_BufferOverFlow;
	}
	return dkc_memcpy(
		ptr->mBuff + offset,
		ptr->mSize - offset
		,data,size);
}




int WINAPI dkcBufferGet(DKC_BUFFER *ptr,void *data,size_t size){
	//if(NULL==ptr) return edk_ArgumentException;//fast
	return dkc_memcpy(data,size,ptr->mBuff,ptr->mSize);
}

int WINAPI dkcBufferGetOffset(DKC_BUFFER *ptr,
															void *data,size_t size,size_t offset){
	if(ptr->mSize < offset + size){
		return edk_BufferOverFlow;
	}
	return dkc_memcpy(
		data,size,
		ptr->mBuff + offset,
		size
	);

}

int WINAPI dkcBufferResize(DKC_BUFFER *ptr,size_t size)
{
	void *NewPtr;
	if(NULL==ptr || 0==size || NULL==ptr->mBuff) return edk_ArgumentException;
	if(DKUTIL_FAILED(dkcReallocate(&NewPtr,size,(void **)&(ptr->mBuff)))){
		return edk_FAILED;
	}

	ptr->mBuff = (BYTE *)NewPtr;
	ptr->mSize = size;

	return edk_SUCCEEDED;
}



DKC_BUFFER* WINAPI dkcAllocBufferCopy(const DKC_BUFFER *ptr){
	dkcmNOT_ASSERT(NULL==ptr || NULL==ptr->mBuff);

	return dkcAllocBuffer(ptr->mBuff,ptr->mSize);
}

size_t WINAPI dkcBufferSize(DKC_BUFFER *p){
	return p->mSize;
}
BYTE *WINAPI dkcBufferPointer(DKC_BUFFER *p){
	return p->mBuff;
}