/*!
@file dkcHMAC.h
@brief HMAC: Keyed-Hashing for Message Authentication
@note
<a href="http://www.weidai.com/scan-mirror/mac.html#HMAC">HMAC</a>
 HMAC(K, text) = H(K XOR opad, H(K XOR ipad, text)) 
http://d.hatena.ne.jp/studiokingyo/20050106

^FHMACɎgMDl͕ł񂩂iH
*/
#ifndef DKUTIL_C_HMAC_H
#define DKUTIL_C_HMAC_H

#include "dkcOSIndependent.h"
#include "dkcHash.h"

/*
typedef int (WINAPI *DKC_HMAC_INIT_F_TYPE)(void *);
typedef void (WINAPI *DKC_HMAC_LOAD_F_TYPE)(void *,const BYTE *pBuffer,DWORD dwSize);
typedef void (WINAPI *DKC_HMAC_FINAL_F_TYPE)(void *p);
typedef int (WINAPI *DKC_HMAC_DIGESTSTR_F_TYPE)(void *p,char *buff,size_t size);
typedef int (WINAPI *DKC_HMAC_DIGEST_F_TYPE)(void *p,BYTE *buff,size_t size);

#define dkcdPAD_BLOCK_SIZE 65
*/
typedef struct dkc_HMAC{
	/*
	DKC_WINAPI_PROC_F_TYPE Init;
	DKC_WINAPI_PROC_F_TYPE Load;
	DKC_WINAPI_PROC_F_TYPE Final;
	DKC_WINAPI_PROC_F_TYPE DigestStr;
	DKC_WINAPI_PROC_F_TYPE Digest;
	///string hash value size
	size_t digest_string_size;
	///binary hash value size
	size_t digest_binary_size;
	*/
	DKC_SECURE_HASH_OBJECT *sho;
	////often 0x36
	BYTE ipad_init;
	//BYTE ipad[dkcdPAD_BLOCK_SIZE];
	BYTE *ipad;
	///often 0x5c
	BYTE opad_init;
	///
	//BYTE opad[dkcdPAD_BLOCK_SIZE];
	BYTE *opad;
	///ipad opad̃TCY
	size_t pad_size;


	BYTE mInnerHashKeyed;
	BYTE mInited;

}DKC_HMAC;


///@note MD5͊ɃNbNHꂽ̂Ŏgp̏͂ȂBSHA512̎gpシB
DKC_EXTERN void WINAPI dkcHMAC_MD5Init(DKC_HMAC *);
DKC_EXTERN void WINAPI dkcHMAC_SHA1Init(DKC_HMAC *);
DKC_EXTERN void WINAPI dkcHMAC_SHA256Init(DKC_HMAC *);
DKC_EXTERN void WINAPI dkcHMAC_SHA384Init(DKC_HMAC *);
///ɂHMAC̐シB
DKC_EXTERN void WINAPI dkcHMAC_SHA512Init(DKC_HMAC *);

typedef void (WINAPI *DKC_HMAC_HASH_INIT_F_TYPE)(DKC_HMAC *);


///@param option[in] edk_SecureHashgp
DKC_EXTERN DKC_HMAC *WINAPI 	dkcAllocHMAC(UINT option);

/*
DKC_EXTERN DKC_HMAC *WINAPI 
	dkcAllocHMAC(
		DKC_WINAPI_PROC_F_TYPE Init,
		DKC_WINAPI_PROC_F_TYPE Load,
		DKC_WINAPI_PROC_F_TYPE Final,
		DKC_WINAPI_PROC_F_TYPE DigestStr,
		DKC_WINAPI_PROC_F_TYPE Digest,
		BYTE ipad,
		BYTE opad,
		size_t digest_size,
		size_t block_size,
		DKC_HMAC_INIT_F_TYPE init_func
);
*/
/*!
@param p[in][out] dkcAllocHMAC()Ŏ擾|C^ւ̃|C^
@return 肭Jłedk_SUCCEEDED
*/
DKC_EXTERN int WINAPI dkcFreeHMAC(DKC_HMAC **p);


void dkcHMAC(DKC_HMAC *,const BYTE *data,size_t data_size,const BYTE *key,size_t key_size,
						 BYTE *bin_result_buff,size_t buffsize);


/**
@param p[in][out] dkcAllocHMAC()Ŏ擾|C^
*/
///DKC_HMACB<s>ʂdkcAllocHMAC() dkcHMACLoad()Ăł薳B</s>
DKC_EXTERN void WINAPI dkcHMACInit(DKC_HMAC *p,const BYTE *key,size_t key_length);

/**
@param p[in][out] dkcAllocHMAC()Ŏ擾|C^
@param pBuffer[in] ǂݎobt@ւ̃|C^
@param dwSize[in] obt@ɃANZXOKȃTCY
*/
DKC_EXTERN void WINAPI dkcHMACLoad(DKC_HMAC *p,const BYTE *pBuffer,DWORD dwSize);


/*!
@param p[in][out] dkcAllocHMAC()Ŏ擾|C^
@note
dkcHMACFinalDigest()gp鎖サ܂B
*/
DKC_EXTERN int WINAPI dkcHMACFinal(DKC_HMAC *p);
/*!
@param p[in][out] dkcAllocHMAC()Ŏ擾|C^
@param buff[out] ރobt@ւ̃|C^
@param size[in] buff̃TCY
@return edk_SUCCEEDEDԂ
*/
///Message Digest擾B
DKC_EXTERN int WINAPI dkcHMACDigestStr(DKC_HMAC *p,char *buff,size_t size);

///oCiMessage Digest擾B
DKC_EXTERN int WINAPI dkcHMACDigest(DKC_HMAC *p,BYTE *buff,size_t size);


#endif //end of include once