/*!
@file dkcMD5.h
@brief MD5 Algorithm
@author wrapped by d
@note
MD5͂łɏIASYȂ̂ŁASHA1pB
܂ASlȂSHA256ȏɂƗǂƎv܂B
*/



#ifndef DKUTIL_C_MD5_H
#define DKUTIL_C_MD5_H

#include "dkcOSIndependent.h"
#include "md5.h"

///MD5oCĩVOl`ۑɕKvȗ̈
#define MD5_BIN_BUFFER_SIZE 16
///MD5̃VOl`ۑɕKvȗ̈
#define MD5_STR_BUFFER_SIZE 33


typedef struct dkc_MD5{
	md5_state_t d;
	BYTE mFinalized;
}DKC_MD5;

/*!
@return DKC_MD5\̂ւ̊mۂ̈
@note
łdkcMD5Init()͌Ă΂Ă܂B
*/
DKC_EXTERN DKC_MD5 *WINAPI dkcAllocMD5();
///@return dkcAllocMD5()擾̈B
DKC_EXTERN void WINAPI dkcMD5Init(DKC_MD5 *);
/*!
@param p[in][out] dkcAllocMD5()Ŏ擾|C^
@param pBuffer[in] ǂݎobt@ւ̃|C^
@param dwSize[in] obt@ɃANZXOKȃTCY
@return edk_SUCCEEDEDŐ
@note
Cu̓sɂAdkcMD5Load()INT_MAX傫obt@Ȃ
*/
DKC_EXTERN int WINAPI dkcMD5Load(DKC_MD5 *p,const BYTE *pBuffer,DWORD dwSize);

///dkcSHA1Load() dkcSHA256Load()ƓdlLoad
DKC_EXTERN void WINAPI dkcMD5LoadStandard(DKC_MD5 *p,const BYTE *pBuffer,DWORD dwSize);


/*!
@param p[in][out] dkcAllocMD5()Ŏ擾|C^
@note
dkcMD5FinalDigest()gp鎖サ܂B
*/
DKC_EXTERN void WINAPI dkcMD5Final(DKC_MD5 *p);
/*!
@param p[in][out] dkcAllocMD5()Ŏ擾|C^
@param buff[out] ރobt@ւ̃|C^
@param size[in] buff̃TCY
@return edk_SUCCEEDEDԂ
*/
DKC_EXTERN int WINAPI dkcMD5DigestStr(DKC_MD5 *p,char *buff,size_t size);
///@see dkcMD5DigestStr()
DKC_EXTERN int WINAPI dkcMD5Digest(DKC_MD5 *p,BYTE *buff,size_t size);

/*!
@see A߂lɂĂdkcMD5Digest()ƓłB 
@note
dkcMD5Final()dkcMD5Digest()gpÅ֐̎gpサ܂B
*/
DKC_EXTERN int WINAPI dkcMD5FinalDigestStr(DKC_MD5 *p,char *buff,size_t size);
///@see dkcMD5FinalDigestStr()
DKC_EXTERN int WINAPI dkcMD5FinalDigest(DKC_MD5 *p,BYTE *buff,size_t size);

/*!
@param p[in][out] dkcAllocMD5()Ŏ擾|C^ւ̃|C^
@return 肭Jłedk_SUCCEEDED
*/
DKC_EXTERN int WINAPI dkcFreeMD5(DKC_MD5 **p);




#endif //end of include once