#ifndef DKC_MEMORY_POOL_H
#define DKC_MEMORY_POOL_H

#include "dkcOSIndependent.h"


typedef struct dkc_SameObjectPoolNode{
	struct dkc_SameObjectPoolNode *next;
}DKC_SAME_OBJECT_POOL_NODE;



typedef struct dkc_SameObjectPool{
	///v[̍ő吔
	size_t max_num;
	///̃v[
	size_t now_num;
	///pool̃TCY
	size_t obj_size;

	///̃v[ւ̃|C^
	DKC_SAME_OBJECT_POOL_NODE *root;
	DKC_SAME_OBJECT_POOL_NODE *tail;

	DKC_ALLOC_FUNC_TYPE alloc_f;
	DKC_FREE_FUNC_TYPE free_f;

}DKC_SAME_OBJECT_POOL;



///
DKC_EXTERN DKC_SAME_OBJECT_POOL *WINAPI 
	dkcAllocSameObjectPool(size_t object_size,size_t max_num,
												DKC_ALLOC_FUNC_TYPE alloc_f,DKC_FREE_FUNC_TYPE free_f);



///@param object_size[in] v[ĂPʂ̃̃TCY
///Ƃ肠AdkcAllocSameObjectPool()̈ǂނ̂ʓ|Ȃ炱ĂłׂB
DKC_EXTERN DKC_SAME_OBJECT_POOL *WINAPI dkcAllocSameObjectPoolAuto(size_t object_size);



///dkcAllocSameObjectPool()Ŋmۂ̈J
DKC_EXTERN int WINAPI dkcFreeSameObjectPool(DKC_SAME_OBJECT_POOL **p);

/*
///dkcAllocSameObjectPool()ŌĂ΂Ă DKC_SAME_OBJECT_POOL \̂̏֐
DKC_EXTERN int WINAPI 
	dkcSameObjectPoolInit(DKC_SAME_OBJECT_POOL *p,size_t object_size,size_t max_num,DKC_ALLOC_FUNC_TYPE func);

///dkcFreeSameObjectPool()ŌĂ΂Ă DKC_SAME_OBJECT_POOL \̂̎gp̌n֐
DKC_EXTERN int WINAPI dkcSameObjectPoolUninit((DKC_SAME_OBJECT_POOL *p,DKC_FREE_FUNC_TYPE func);
*/
/**
@note
Ƀv[ȂȂĂdkcAllocSameObjectPool()Ŏw肵max_numv[Ȃ܂B
NULLԂpxmallocƓƎv܂B
*/
///@return dkcAllocSameObjectPool()object_sizeŎw肵TCỸ̈
DKC_EXTERN void *dkcSameObjectPoolAlloc(DKC_SAME_OBJECT_POOL *p);

/**
@note
̊֐̎dl͏サ܂B
ȂȂpvɓ郁AhXłԈG[ɒ邩łB
fdkcSameObjectPoolReserve()dkcSameObjectPoolFree()őΉłB
*/
///dkcSameObjectPoolAlloc()Ŋmۂ̈ėpׂɕԂ֐(gp͏サ܂j

DKC_EXTERN void WINAPI dkcSameObjectPoolRecycle(DKC_SAME_OBJECT_POOL *p, void *pv);


DKC_EXTERN int WINAPI dkcSameObjectPoolReserve(DKC_SAME_OBJECT_POOL *p);

///dkcSameObjectPoolAlloc()Ŋmۂ̈𑦍sfree()Ă܂B
#define dkcSameObjectPoolFree(p) dkcFree((void **)&(p))

#if 0


typedef struct dkc_MemoryPool{
	BYTE *mpool;

	///v[
	DKC_ARRAY_ONEBYONE *mAobo;

}DKC_MEMORY_POOL;


DKC_EXTERN DKC_MEMORY_POOL *WINAPI dkcAllocMemoryPool(size_t poolsize,UINT flag);

DKC_EXTERN int WINAPI dkcFreeMemoryPool(DKC_MEMORY_POOL **);


DKC_EXTERN void *WINAPI dkcMemoryPoolAlloc(size_t size);

DKC_EXTERN int WINAPI dkcMemoryPoolFree(void *p);

DKC_EXTERN int WINAPI dkcMemoryPoolSafeFree(void **pp);

#endif

#endif
