/*!
@file dkcMemoryStream.h
@note
dkcMemoryStreamSerializẽVACYς݃t@Cf[^\

DKC_MEMORYSTREAM\
BYTE DKC_MEMORYSTREAM::mSizeB
@brief ϒȔzԂ߂Bstd::vector݂Ȃ́B


*/

#ifndef DKUTIL_C_MEMORYSTREAM_H
#define DKUTIL_C_MEMORYSTREAM_H


#include "dkcOSIndependent.h"

#include "dkcDefined.h"
#include "dkcBuffer.h"

/*!
Xg[\́Bfopen fwrite freadōs悤ȃXg[B
Cstd::vector݂ȊŎgB
*/
typedef struct dkc_MemoryStream{
	///obt@
	BYTE *mBuffer;
	///obt@̃TCY
	size_t mSize;
	///̃ItZbg
	size_t mNowOffset;
	
}DKC_MEMORYSTREAM;





enum edkcMemoryStream{
	///̈ʒuV[N
	edkcMemoryStreamSeekCurrent = edkcSeekCurrent,
	///Ō̈ʒuV[N
	edkcMemoryStreamSeekEnd = edkcSeekEnd,
	///ŏ̈ʒuV[N
	edkcMemoryStreamSeekSet = edkcSeekSet,


};



/**
@param flag[in] edkcMemoryStreamɂAStreamInitn̂̂n
@param size[in] Xg[̏̃TCY
@param filename[in] edkcMemoryStreamInitFileflagɓnꍇA̕ۑt@C̖O
flagedkcMemoryStreamInitFileȊO̒lnꍇNULLOK
@param mode[in] fopeñ[h
flagedkcMemoryStreamInitFileȊO̒lnꍇNULLOK
@return DKC_MEMORYSTREAM *̃Xg[f[^B
*/
///Xg[̈𓾂B
DKC_EXTERN DKC_MEMORYSTREAM * WINAPI dkcAllocMemoryStream(size_t size);


/*!
@param ptr[in][out] 폜Xg[f[^Bꂽf[^NULLɂȂB
*/
///dkcAllocNewStream()ŊmۂXg[̈J
DKC_EXTERN int WINAPI dkcFreeMemoryStream(DKC_MEMORYSTREAM **ptr);


///streamV[NBfseek݂Ȃ
DKC_EXTERN int WINAPI dkcMemoryStreamSeek(DKC_MEMORYSTREAM *ptr,int offset,int origin);

///@return stream̃V[N|CgԂB
DKC_EXTERN size_t WINAPI dkcMemoryStreamGetSeekPoint(DKC_MEMORYSTREAM *ptr);

#define dkcMemoryStreamTell(tt) dkcMemoryStreamGetSeekPoint(tt)

/*!
@param readsize[out] ۂɓǂ񂾃TCYԂBNULLnĂOK.
@note
w肵TCY(size)Xg[obt@̃TCYꍇ
readsizeɎۂɓǂ񂾃TCY܂B
*/
///stream[hBfread݂Ȃ
DKC_EXTERN int WINAPI dkcMemoryStreamRead(DKC_MEMORYSTREAM *ptr,void *buffer,size_t size,size_t *readsize);
/*!
@note
Xg[obt@͓IgłBCɂǂǂԂ݂܂傤B
CłSTLstd::vector݂Ȃ̂łˁBiƂ܂Aԗւ̍ĊJĂ邵B

*/
///streamCgBfwrite݂Ȃ
DKC_EXTERN int WINAPI dkcMemoryStreamWrite(DKC_MEMORYSTREAM *ptr,const void *buffer,size_t size);

///streamCgBCgoȂœIgB
DKC_EXTERN int WINAPI dkcMemoryStreamDynamicWrite(DKC_MEMORYSTREAM *ptr,const void *buffer,size_t size);

///stream̃obt@gB
DKC_EXTERN int WINAPI dkcMemoryStreamResize(DKC_MEMORYSTREAM *ptr,size_t want_size);
///@return Aǂ܂ŏł邩̃TCY擾
DKC_EXTERN size_t WINAPI dkcMemoryStreamNowOffset(DKC_MEMORYSTREAM *p);
///@return obt@ւ̃|C^擾
DKC_EXTERN BYTE *WINAPI dkcMemoryStreamPointer(DKC_MEMORYSTREAM *p);



///streammemset(0)B(seekʒuŏɖ߂B
DKC_EXTERN int WINAPI dkcMemoryStreamClear(DKC_MEMORYSTREAM *ptr);


/*!
@return 炻̃IuWFNgւ̃|C^ԂBsNULLԂB
@note
C++ŌRs[RXgN^B
*/

DKC_EXTERN DKC_MEMORYSTREAM * WINAPI dkcAllocMemoryStreamCopy(const DKC_MEMORYSTREAM *ptr);


//DKC_EXTERN int WINAPI dkcMemoryStreamPushBack(DKC_MEMORYSTREAM *p,const BYTE *buff,size_t size);

///obt@I[o[t[\܂B\mȂƊ댯łB
#define dkcMemoryStreamPushBackMacro(type,p,x) {\
	*((type *)&( (p)->mBuff[(p)->mNowOffset])) = (type)x;(p)->mNowOffset += sizeof(type);\
}

#define dkcMemoryStreamIsEnd(p) ( (p)->mNowOffset >= (p)->mSize )

DKC_EXTERN int WINAPI dkcMemoryStreamPopBack(DKC_MEMORYSTREAM *p,size_t size);

//**********************************************************
//memory stream adapter

#if 0
typedef struct dkc_MemoryStreamAdapter{
	BYTE *mBuffer;
	size_t mSize;
	size_t mNowOffset;
}DKC_MEMORYSTREAM_ADAPTER;
#else
///\̂typedefŏ\
typedef DKC_MEMORYSTREAM DKC_MEMORYSTREAM_ADAPTER;
#endif

DKC_EXTERN void WINAPI dkcMemoryStreamAdapterInit(DKC_MEMORYSTREAM_ADAPTER *p,BYTE *buff,size_t size);

DKC_EXTERN DKC_MEMORYSTREAM_ADAPTER *WINAPI dkcAllocMemoryStreamAdapter(BYTE *buff,size_t size);

DKC_EXTERN int WINAPI dkcFreeMemoryStreamAdapter(DKC_MEMORYSTREAM_ADAPTER **);

#define dkcMemoryStreamAdapterWrite(a,b,c) dkcMemoryStreamWrite(a,b,c)
#define dkcMemoryStreamAdapterRead(a,b,c,d) dkcMemoryStreamRead(a,b,c,d)
#define dkcMemroyStreamAdapterSeek(a,b,c) dkcMemoryStreamSeek(a,b,c)
#define dkcMemoryStreamAdapterTell(a) dkcMemoryStreamTell(a)
#define dkcMemoryStreamAdapterClear(a) dkcMemoryStreamClear(a)
/*
DKC_EXTERN BYTE *WINAPI dkcMemoryStreamAdapterPointer(DKC_MEMORYSTREAM_ADAPTER *p);

DKC_EXTERN size_t WINAPI dkcMemoryStreamAdapterSize(DKC_MEMORYSTREAM_ADAPTER *p);

DKC_EXTERN int WINAPI dkcMemoryStreamAdapterSetOffset(DKC_MEMORYSTREAM_ADAPTER *ptr,size_t offset);

DKC_EXTERN size_t WINAPI dkcMemoryStreamAdapterGetOffset(DKC_MEMORYSTREAM_ADAPTER *p);

DKC_EXTERN int WINAPI dkcMemoryStreamAdapterRead(DKC_MEMORYSTREAM_ADAPTER *p,void *buff,size_t buffsize,size_t *readsize);


///@see dkcMemoryStreamAdapterPushBack()
#define dkcMemoryStreamAdapterWrite(p,buff,write_size) dkcMemoryStreamAdapterPushBack(p,buff,write_size)

DKC_EXTERN int WINAPI dkcMemoryStreamAdapterGetChar(DKC_MEMORYSTREAM_ADAPTER *p,BYTE *t);
*/
//**********************************************************
//stream generic macro
/*
///Xg[ñobt@t@C_v܂B
#define dkcmMemoryStreamDump(ptr,filename,buffer_all) {\
	if(buffer_all){\
		dkcSaveBinary(ptr->mBuffer,ptr->mSize,filename);\
	}else{\
		dkcSaveBinary(ptr->mBuffer,ptr->mNowOffset,filename);\
	}\
}
*/
enum{
	edkcDumpRegistBufferAll = 0,
	edkcDumpNowOffset = 1,
};
DKC_EXTERN int WINAPI dkcMemoryStreamDump(DKC_MEMORYSTREAM *ptr,const char *filename,UINT flag);

///Xg[̃obt@bufferɃRs[ @param flag[in] 
DKC_EXTERN int WINAPI dkcMemoryStreamWriteToMemory(const DKC_MEMORYSTREAM *ptr,void *buffer,size_t buffsize,UINT flag);
///buffermemorystreamɓǂ݂
DKC_EXTERN int WINAPI dkcMemoryStreamLoadFromMemory( DKC_MEMORYSTREAM *ptr,const void *buffer,size_t buffsize);
 ///t@Cmemorystreamɓǂ݂
DKC_EXTERN int WINAPI dkcMemoryStreamLoadFromFile(DKC_MEMORYSTREAM *ptr,const char *filename,size_t permit_size,UINT flag);

DKC_EXTERN int WINAPI dkcMemoryStreamGet8(DKC_MEMORYSTREAM *ptr,BYTE *t);
DKC_EXTERN int WINAPI dkcMemoryStreamPut8(DKC_MEMORYSTREAM *Ptr,BYTE t);

#endif
