/**
@file dkcStream.h
@note
t@CXg[ƃXg[̃A_v^[VXe
GfBAnlVXe

DKC_STREAM\
BYTE DKC_STREAM::mSizeB



*/

#ifndef DKUTIL_C_STREAM_H
#define DKUTIL_C_STREAM_H


#include "dkcOSIndependent.h"
#include "dkcMemoryStream.h"


///ėp^Xg[
typedef struct dkc_Stream{
	UINT mMode;
	///endian  `FWȂTRUE
	BYTE mChangeEndian;
	///vZX̏ڍ
	BYTE mProcessMode;
	/*union{
		DKC_MEMORYSTREAM *mmem;
		FILE *mfp;
	}uni;*/
	void *mSig;
}DKC_STREAM;

//#error streamSEEKReadpWritepB


enum edkcStream{
	///̈ʒuV[N
	edkcStreamSeekCurrent = SEEK_CUR,
	///Ō̈ʒuV[N
	edkcStreamSeekEnd = SEEK_END,
	///ŏ̈ʒuV[N
	edkcStreamSeekSet = SEEK_SET,
	///obt@Ƃď
	edkcStreamInitMemory = 1,
	///obt@fopenŏ
	edkcStreamInitFile = 2,
	///GfBAftHg
	edkcStreamDefaultEndian = 4,
	///rbOGfBA[h
	edkcStreamBigEndian = 8,
	///gGfBA[h
	edkcStreamLittleEndian = 16,
	///dkcStreamRead() dkcStreamWrite()̋ w肵TCYǂݍ߂Ȃꍇ͕Ԃ
	edkcStreamProcessDefault = 32,
	///dkcStreamRead() dkcStreamWrite()̋ w肵TCY s iG[̎Ԃ)
	edkcStreamProcessAsOrdered = 64,
	///dkcStreamRead() dkcStreamWrite()̋
	///IȃGfBA`FWoȂ݁An֐ɂ
	///GfBA`FWKv̏ꍇedk_Not_SatisfactoryԂ悤Ɏw
	edkcStreamWriteErrorWhenEndianChange = 128,
	
	///obt@w̃Xg[ṎZbgăA_v^[ƂĎgpƂɎwB
	///dkcMemoryStreamAdaptern݂ȁ`B
	edkcStreamInitMemoryAdapter = 256,
	
	edkcStreamWin32PromoteFlag = edkcStreamLittleEndian | edkcStreamProcessAsOrdered,
	edkcStreamMacPromoteFlag = edkcStreamBigEndian | edkcStreamProcessAsOrdered,

};

//**********************************************************


/**
@param flag[in] edkcStreamɂAwñtOn(Xg[̎ނƃXg[̃GfBA)
@param default_data[in] Xg[ɋlߍރobt@ʂNULLłOK
@param size[in] Xg[̏̃TCY
@param filename[in] edkcStreamInitFileflagɓnꍇA̕ۑt@C̖O
flagedkcStreamInitFileȊO̒lnꍇNULLOK
@param mode[in] fopeñ[h
flagedkcStreamInitFileȊO̒lnꍇNULLOK
@return DKC_STREAM *̃Xg[f[^B
*/
///Xg[̈𓾂B
DKC_EXTERN DKC_STREAM * WINAPI dkcAllocStream(UINT flag,const void *default_data,size_t size,const char *filename,const char *mode);

DKC_EXTERN DKC_STREAM *WINAPI dkcAllocStreamMemoryType(UINT flag,const void *default_data,size_t size);

DKC_EXTERN DKC_STREAM *WINAPI dkcAllocStreamFileType(UINT flag,const char *filename,const char *mode);
/**

@note
adapt_bufferɓꂽ͎̈IɊJ܂̂ŊeŊJĂB
*/
DKC_EXTERN DKC_STREAM *WINAPI dkcAllocStreamMemoryAdapterType(UINT flag,void *adapt_buffer,size_t size);
/**
@param OrderFlag[in] w肵ʂɓǂ݂ރ^CvȂTRUE (edkcStreamProcessAsOrdered)
@note
dlFIɓfot@C̃GfBA̓gGfBA
*/
///t@CpXg[̗̈𓾂鎞̏ł̊֐
DKC_EXTERN DKC_STREAM *WINAPI dkcAllocStreamEncouragementFileType(const char *filename,const char *mode,BOOL OrderFlag);

/*!
@param ptr[in][out] 폜Xg[f[^Bꂽf[^NULLɂȂB
@note

*/
///dkcAllocNewStream()ŊmۂXg[̈J
DKC_EXTERN int WINAPI dkcFreeStream(DKC_STREAM **ptr);

//**********************************************************
///streamV[NBfseek݂Ȃ @return edk_SUCCEEDEDŐ@ȊO̓G[
DKC_EXTERN int WINAPI dkcStreamSeek(DKC_STREAM *ptr,int offset,int origin);

///stream̈ʒu擾B @return edkcStreamSeekSet̃ItZbglBedk_FAILEDƃG[
DKC_EXTERN long WINAPI dkcStreamTell(DKC_STREAM *ptr);

///streammemset(0)B(seekʒuŏɖ߂B
DKC_EXTERN int WINAPI dkcStreamClear(DKC_STREAM *ptr);


///Xg[tbViSɏޏjB
///@return edk_Result̂ǂꂩ
DKC_EXTERN int WINAPI dkcStreamFlush(DKC_STREAM *ptr);

///@return EOFTRUE
DKC_EXTERN BOOL WINAPI dkcStreamEOF(DKC_STREAM *ptr);
///@return G[TRUE
DKC_EXTERN BOOL WINAPI dkcStreamError(DKC_STREAM *ptr);

//**********************************************************
/*!
@param readsize[out] ۂɓǂ񂾃TCYԂBNULLnĂOK.
@note
w肵TCY(size)Xg[obt@̃TCYꍇ
readsizeɎۂɓǂ񂾃TCY܂B


@return 
edkcStreamInitMemoryw肳ĂꍇA
 dkcMemoryStreamRead()ĂB
edkcStreamInitFilew肳ĂꍇA
 ferror()edk_FAILED , feof()edk_BufferOverFlow,
edkcStreamWriteErrorWhenEndianChangew肳ĂꍇA
 edk_Not_SatisfactoryԂB̏ꍇdkcStreamRead8()gp鎖
*/
///stream[hBfread݂Ȃ
DKC_EXTERN int WINAPI dkcStreamRead(DKC_STREAM *ptr,void *buffer,size_t size,size_t *readsize);


/**
size1bytePʥ@ԂႯdkcStreamRead()ƓB
GfBAɐϋɓIɎgވׂ
edkcStreamWriteErrorWhenEndianChangew肳Ăꍇ͖IɂgpB
*/
DKC_EXTERN int WINAPI dkcStreamRead8(DKC_STREAM *ptr,void *buffer,size_t size,size_t *readsize);


/**
@note
size2bytePʂłȂƂȂ
@param flag[in] edkcStreamProcessAsOrdered w肵TCYœǂ݂߂Ȃ
	edkcStreamProcessDefault
@todo test
*/
DKC_EXTERN int WINAPI dkcStreamRead16(DKC_STREAM *ptr,void *buffer,size_t size,size_t *readsize);
/**
@note
size4bytePʂłȂƂȂ
*/

DKC_EXTERN int WINAPI dkcStreamRead32(DKC_STREAM *ptr,void *buffer,size_t size,size_t *readsize);
/**
@note
size8bytePʂłȂƂȂ
*/
DKC_EXTERN int WINAPI dkcStreamRead64(DKC_STREAM *ptr,void *buffer,size_t size,size_t *readsize);


//**********************************************************

///stream̒gB
DKC_EXTERN int WINAPI dkcStreamRef(DKC_STREAM *ptr,void *buffer,size_t size,size_t *readsize);

/**

*/
DKC_EXTERN int WINAPI dkcStreamRef8(DKC_STREAM *ptr,void *buffer,size_t size,size_t *readsize);

DKC_EXTERN int WINAPI dkcStreamRef16(DKC_STREAM *ptr,void *buffer,size_t size,size_t *readsize);
/**
@note
size4bytePʂłȂƂȂ
*/

DKC_EXTERN int WINAPI dkcStreamRef32(DKC_STREAM *ptr,void *buffer,size_t size,size_t *readsize);
/**
@note
size8bytePʂłȂƂȂ
*/
DKC_EXTERN int WINAPI dkcStreamRef64(DKC_STREAM *ptr,void *buffer,size_t size,size_t *readsize);


//**********************************************************


/*!
@note
Xg[obt@͓IgłBCɂǂǂԂ݂܂傤B
CłSTLstd::vector݂Ȃ̂łˁBiƂ܂Aԗւ̍ĊJĂ邵B

*/
///streamCgBfwrite݂Ȃ

DKC_EXTERN int WINAPI dkcStreamWrite(DKC_STREAM *ptr,const void *buffer,size_t size);

DKC_EXTERN int WINAPI dkcStreamWrite8(DKC_STREAM *ptr,void *buffer,size_t size);

DKC_EXTERN int WINAPI dkcStreamWrite16(DKC_STREAM *ptr,const void *buffer,size_t size);

DKC_EXTERN int WINAPI dkcStreamWrite32(DKC_STREAM *ptr,const void *buffer,size_t size);

DKC_EXTERN int WINAPI dkcStreamWrite64(DKC_STREAM *ptr,const void *buffer,size_t size);


//**********************************************************

/*!
@param p[in] DKC_STREAM *
@param buffer[in][out] ꍇɂinAoutɂȂBobt@ւ̃|C^
@param size[in] buffer̃TCY
@param data[in] Ǝf[^ւ̃|C^󂯎
*/
typedef int (WINAPI *DKC_STREAM_PROCESS_TYPE)(DKC_STREAM *p,void *buffer,size_t size,void *data);


DKC_EXTERN int WINAPI dkcStreamProcess(DKC_STREAM *ptr,void *buffer,size_t size,
																			 DKC_STREAM_PROCESS_TYPE write_t,void *data);

DKC_EXTERN int WINAPI dkcStreamProcess16(DKC_STREAM *ptr,void *buffer,size_t size,
																			 DKC_STREAM_PROCESS_TYPE write_t,void *data);

DKC_EXTERN int WINAPI dkcStreamProcess32(DKC_STREAM *ptr,void *buffer,size_t size,
																			 DKC_STREAM_PROCESS_TYPE write_t,void *data);

DKC_EXTERN int WINAPI dkcStreamProcess64(DKC_STREAM *ptr,void *buffer,size_t size,
																			 DKC_STREAM_PROCESS_TYPE write_t,void *data);






#endif
