/*!
@file dkcString.h
@author d
@since 2004/2/28
@note
SYNHPBhttp://www.emit.jp/@SHIFT-JIŠ̃̕R[h𒸂܂B
̏؂肵Ă\グ܂Bm(_ _)m<br>
<br>
SHIFT-JIS(ȉ SJIS)
@brief 񏈗
*/
#ifndef DKUTIL_C_STRING_H
#define DKUTIL_C_STRING_H


#include "dkcOSIndependent.h"
#include "dkcMemoryStream.h"




#define UCHAR_MAX_STR "255"
///unsigned char MAX̒̕iNULL) 
#define UCHAR_MAX_STR_LEN 3


#define USHRT_MAX_STR "65535"

#define USHRT_MAX_STR_LEN 5

///(signed)  short ̍ől ̕
#define SHRT_MAX_STR "32767" 

#define SHRT_MAX_STR_LEN 5

/// (signed)  short ̍ŏl ̕
#define SHRT_MIN_STR "-32768"

#define SHRT_MIN_STR_LEN 6

///(signed)  int ̍ől̕
#define INT_MAX_STR "2147483647"

#define INT_MAX_STR_LEN 10

///(0xffffffff) unsigned int ̍ől̕ 
#define UINT_MAX_STR "4294967295"

#define UINT_MAX_STR_LEN 10

///INT_MIN̕
#define INT_MIN_STR "-2147483648"


#define INT_MIN_STR_LEN 11

///(0xffffffff) unsigned int ̍ől ̕
#define ULONG_MAX_STR "4294967295"

#define ULONG_MAX_STR_LEN 10

#define LONGLONG_MAX_STR "9223372036854775807"

#define LONGLONG_MAX_STR_LEN 19

#define LONGLONG_MIN_STR "-9223372036854775808"

#define LONGLONG_MIN_STR_LEN 20

#define ULONGLONG_MAX_STR "18446744073709551615"

#define ULONGLONG_MAX_STR_LEN 20

///doubleő̂Ƃ̕
#define DBL_MAX_STR "179769313486231570000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000.000000"
///doubleő̂Ƃ̌i)
#define DBL_MAX_STR_LEN 316

///doubleŏ̂Ƃ̕
#define DBL_MIN_STR "0.000000"
///doubleŏ̂Ƃi)
#define DBL_MIN_STR_LEN 8 

/*
extern const BYTE SJIS1_S1 ;
extern const BYTE SJIS1_E1 ;
extern const BYTE SJIS1_S2 ;
extern const BYTE SJIS1_E2 ;

// SJIŜQoCgڂ̃R[h
extern const BYTE SJIS2_S1 ;
extern const BYTE SJIS2_E1 ;
extern const BYTE SJIS2_S2 ;
extern const BYTE SJIS2_E2 ;
*/
///@see dkcIsSJIS1()
#define dkcmIsSJIS1(c) dkcIsSJIS1(c)/*((c ^= 0x20) && (c >= (SJIS1_S1 ^ 0x20) && c <= (SJIS1_E2 ^ 0x20)))*/
///@see dkcIsSJIS2()
#define dkcmIsSJIS2(c) dkcIsSJIS2(c)/*(c >= SJIS2_S1 && c <= SJIS2_E1) || (c >= SJIS2_S2 && c <= SJIS2_E2)*/


enum edkcString{
	edkcCHARString = 1,
	edkcWCHARString,
};
/*!
i[\́iC++STLstd::string݂Ȃ́j
*/
typedef struct dkc_String{
	DKC_MEMORYSTREAM *mStream;
	///gpĂbyte
	size_t mByteSize;
}DKC_STRING;


///@return cSJIŜPoCgڂ̎TRUE(1)
DKC_EXTERN BOOL dkcIsSJIS1(BYTE c);
///@return cSJIŜQoCgڂ̎TRUE(1)
DKC_EXTERN BOOL dkcIsSJIS2(BYTE c);
///@return pSpʂȂSpacen̕TRUE
DKC_EXTERN BOOL dkcIsSpace(BYTE c);
///@return ł镶萔TRUE
//DKC_EXTERN BOOL dkcIsVisible
DKC_EXTERN const char *dkcGetSpaceSeparator();



/// SJISOĕ @return ŏɌʒuԂ -1Ȃ猩Ȃ
DKC_EXTERN int WINAPI dkcSJIS_StrChrSearch(const char *s, char c);

/// SJISOĕ @return ŌɌʒuԂ -1Ȃ猩Ȃ
DKC_EXTERN int WINAPI dkcSJIS_StrChrSearchLast(const char *s, char c);

/*!
SJISOĕ납猟 
@return 납猟čŏɌʒuԂ -1Ȃ猩Ȃ
@note It has not tested. 
*/
DKC_EXTERN int WINAPI dkcSJIS_StrChrSearchTail(const char *s,size_t len,char c);

/*!
̕萔włdkcSJIS_StrChrSearch()
///@note It has not tested. 
*/
DKC_EXTERN int WINAPI dkcSJIS_StrChrSearchInStr(const char *s,const char *c);
///@note It has not tested. 	
DKC_EXTERN int WINAPI dkcSJIS_StrChrSearchInStrLast(const char *s, const char *c);
///@return pXZp[^ŏɌʒuԂB@return -1͌Ȃ
DKC_EXTERN int WINAPI dkcSJIS_SearchPathSep(const char *s);
///@return pXZp[^ŊɌʒuԂB@return -1͌Ȃ
DKC_EXTERN int WINAPI dkcSJIS_SearchPathSepLast(const char *s);

/*! strstrWrapper
@return ŏɌʒuԂ -1Ȃ猩Ȃ -2ƁA܂ɂ񂪗ꂷĂĕ\łȂB
*/
DKC_EXTERN int WINAPI dkcStrStr(const char *dest,const char *src);
/*!
strstrBM@łĂ݂
@return ŏɌʒuԂ -1Ȃ猩Ȃ
///@note It has not tested. 
*/
DKC_EXTERN int WINAPI dkcBMStrStr(const char *dest,const char *src);


//**********************************************************
//i[CuiSTLstd::string݂ȁ`


DKC_EXTERN DKC_STRING * WINAPI dkcAllocString(size_t size);

DKC_EXTERN int WINAPI dkcFreeString(DKC_STRING **ptr);

DKC_EXTERN int WINAPI dkcStringCopy(DKC_STRING *ptr,const char *str,size_t size);
///http://www.google.com/search?num=50&hl=ja&lr=lang_ja&q=strcat+cat%82%c6%82%cd
DKC_EXTERN int WINAPI dkcStringConcatenate(DKC_STRING *ptr,const char *str,size_t size);
/*!
@param ptr[in][out] dkcAllocString()Ŋmۂ|C^
@param point[in] ڈȍ~ɑ}̂
@param str[in] }
@param size[in] str̕B
@todo eXgB̊֐̎͏X̂ŒB
*/
DKC_EXTERN int WINAPI dkcStringInsert(DKC_STRING *ptr,size_t point,const char *str,size_t size);
/*!
@param ptr[in][out] dkcAllocString()Ŋmۂ|C^
@param point[in] ڈȍ~폜̂
@param len[in] point牽Erase邩B
@return edk_SUCCEEDEDȂ犮SB<br>
edk_Not_SatisfactoryȂlen傫铙̗Rꉞ͏ovʂɂ͂ȂȂB<br>
̑̓G[
@todo test
*/
DKC_EXTERN int WINAPI dkcStringErase(DKC_STRING *ptr,size_t point,size_t len);
/*!
@param ptr[in][out] dkcAllocString()Ŋmۂ|C^
@param begin_[in] (ڂ
@param end_[in] ܂(ڂ܂)ӁFbegin_n byte܂Ł@Ƃł͂ȂB
@param str[in] u
@param size[in] str̕B
@todo eXgB̊֐̎͏X̂ŒB
*/
DKC_EXTERN int WINAPI dkcStringReplace(DKC_STRING *ptr,size_t begin_,size_t end_,const char *str,size_t size);



///@return ̕ԂBstreamstrlenɂ̂ۑĂ̂擾B
DKC_EXTERN size_t dkcStringNum(const DKC_STRING *ptr);

DKC_EXTERN size_t dkcStringSize(const DKC_STRING *ptr);


DKC_EXTERN const char * WINAPI dkcStringPointer(const DKC_STRING *ptr);

///DKC_STRING̓obt@ɂԂ
DKC_EXTERN int WINAPI dkcStringGetBuffer(const DKC_STRING *ptr,char *buffer,size_t buffsize);

#if 0
///@note It has not tested. 
DKC_EXTERN int WINAPI dkcStringSerialize(const DKC_STRING *ptr,DKC_SERIALIZE *);
///@note it has not tested.
DKC_EXTERN DKC_STRING* WINAPI dkcAllocStringDeserialize(DKC_DESERIALIZE *se);
#endif


#endif
