/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	Appentry.cpp
 *
 *****************************************************************************/

// SOL++2000
// 2000.06.15 Fixed a bug on argv of a commandline string.

#include <sol\Application.h>
#include <sol\CommandLine.h>
#define _MAX_ARG  100


int APIENTRY WinMain(HINSTANCE progIns, HINSTANCE prevIns, 
		   LPSTR cmdLine, int cmdShow)
{
	static char* Copyright = "Copyright (c) 1999-2000 TOSHIYUKI ARAI(antillia.com). ALL RIGHTS RESERVED."; 

	Application::initialize(progIns, prevIns, cmdLine, cmdShow);

	static int argc = 0;
	static char* argv[_MAX_ARG];
	static char module[_MAX_PATH];
	static CommandLine commandLine(cmdLine);

	::GetModuleFileName(progIns, module, sizeof(module));
	argv[argc++] = module;

	//<modified date="2000.06.15">
	// argc +=  commandLine.getArgv(argv, _MAX_ARG);
	argc +=  commandLine.getArgv(&argv[argc], _MAX_ARG);
	//</added>
	Main(argc, argv);

	return TRUE;
}
