/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	Application.h
 *
 *****************************************************************************/

// SOL++2000
// 2001/04/01 Added a static variable DEFAULT_WIN_CLASS_STYLE


#ifndef _SOL_OBJECT
#include <sol\Object.h>
#endif
#ifndef _SOL_ARGS
#include <sol\Args.h>
#endif
#ifndef _SOL_HASHTABLE
#include <sol\HashTable.h>
#endif

#ifndef _SOL_APPLICATION
#define _SOL_APPLICATION

class View;
class Composite;

class Application :public Object {
	static const char* name;
	static HINSTANCE  instance;
	static HINSTANCE  prevInstance;
	static HashTable* table;
	static LPSTR	cmdLine;
	static int		cmdShow;
	static int		argc;
	static char**	argv;
	static Composite* toplevel;
	static HINSTANCE    richEdit;

	int		dialogMessage(MSG* msg);

  public:
	static long	DEFAULT_WIN_CLASS_STYLE;

  public:
	Application(const char* name, int argc, char** argv);

	~Application();

	static void	 add(HWND hwnd, View* view) {
			table -> add((Key)hwnd, (Object*)view);
	}
	static View*	 lookup(HWND hwnd) {
			return (View*)table->lookup((Key)hwnd);
	}
	static BOOL	 remove(HWND hwnd) {
			return	table->remove((Key)hwnd);
	}
	static const char*  getName() { return name; }

	static HINSTANCE	getInstance() { return instance; }

	static HINSTANCE	getPrevInstance() { return prevInstance; } 

	static void	initialize(HINSTANCE progIns, HINSTANCE prevIns, 
					LPSTR cmdLine1, int cmdShow1);

	static BOOL	 registerClass(Args& args);

	WPARAM	run();

	void	setToplevel(Composite* appview) {
			toplevel = appview;
	}

	LPSTR	getCommandLine() { return cmdLine; }

	int		getShowCommand() { return cmdShow; }
};

void	Main(int argc, char** argv);

#endif

