/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	ApplicationView.h
 *
 *****************************************************************************/

// SOL++2000

#ifndef _SOL_APPLICATION
#include <sol\Application.h>
#endif
#ifndef _SOL_COMPOSITE
#include <sol\Composite.h>
#endif
#ifndef _SOL_MENUBAR
#include <sol\MenuBar.h>
#endif
#ifndef _SOL_ACCELERATOR
#include <sol\Accelerator.h>
#endif
#ifndef _SOL_TOOLBAR
#include <sol\ToolBar.h>
#endif
#ifndef _SOL_STATUSBAR
#include <sol\StatusBar.h>
#endif
#ifndef _SOL_DEFAULTLAYOUT
#include <sol\DefaultLayout.h>
#endif

#ifndef _SOL_APPLICATIONVIEW
#define _SOL_APPLICATIONVIEW

class ApplicationView :public Composite {
	Application& 	application;
	MenuBar*     	menuBar;
	Accelerator* 	accel;
	ToolBar*		toolBar;
	StatusBar*		statusBar;
	DefaultLayout*	defaultLayout;

  protected:
  	virtual long size(Event& event);

  public:
	ApplicationView(Application& applet, const char* name, Args& args);
	~ApplicationView();
	void	  exit(Action& action) {
			post(WM_CLOSE, 0, 0L);
	}
	virtual void getClientRect(RECT* r);	
	StatusBar* getStatusBar() { return statusBar; }
	ToolBar*   getToolBar() { return toolBar; }

	MenuBar*  getMenuBar()  { return menuBar; }
	BOOL	isIconic() { return ::IsIconic(getWindow()); }
	BOOL	isZoomed() { return ::IsZoomed(getWindow()); }
	void	realize();
	void	setToolBar(ToolBar* bar)   { toolBar = bar; }
	void	setStatusBar(StatusBar* bar) { statusBar = bar; }

	BOOL	translate(MSG* msg);

	int		showMessageDialog(const char* message, int flag = MB_OK);
	int		showMessageDialog(const char* title, const char* message, int flag = MB_OK);
	void	wait(LONG interval); 
	void	restorePlacement(const char* name = NULL);
	void	savePlacement(const char* name = NULL);

};

#endif

