/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	BinaryBinaryNode.cpp
 *
 *****************************************************************************/

// SOL++2000

#include <sol\BinaryNode.h>
#include <sol\stdio.h>

BinaryNode::BinaryNode(BinaryNode* parent1, const char* name1, 
					   Object* object1)
	:x(0.0),
	y(0.0),
	name(null),
	parent(parent1),
	object(object1),
	left(null),
	right(null)
{
	if(name1) {
		name = new char[strlen(name1)+1];
		strcpy(name, name1);
	}
}



BinaryNode::BinaryNode(BinaryNode* parent1, const char*  name1, 
		BinaryNode* left1, BinaryNode* right1)
	:x(0.0),
	y(0.0),
	name(null),
	parent(parent1),
	object(null),
	left(left1),
	right(right1)
{
	if (name1) {
		name = new char[strlen(name1)+1];
		strcpy(name, name1);
	}
}


BinaryNode::~BinaryNode()
{
	delete [] name;
	delete object;
	delete left;
	delete right;
}


int BinaryNode::configure(int nx, int ny)
{
	x = (float)nx;
	y = (float)ny;

	nx++;
	int num = 0;
	int n = ny;
	if (left) {
		n = left -> configure(nx, n);
		n++;
		num++;
	}
	if (right) {
		n = right -> configure(nx, n);
		n++;
		num++;
	}

	if (num > 0) n--;
	return n;
}


float BinaryNode::reconfigure()
{
	int   num = 0;
	float sum = (float)0.0;
	if (left) {
		sum = sum +	left -> reconfigure();
		num++;
	}
	if (right) {
		sum = sum +	right -> reconfigure();
		num++;
	}

	if (right) {

	}
	if (num > 0) y = sum/(float)num;
	return y;
}


BinaryNode* BinaryNode::search(const char* name1)
{
	BinaryNode* found = null;

	if (name1 == NULL || *name1 == Zero) {
		return NULL;
	}

	if (strcmp(name, name1) == 0) {
		return this;
	}
	if (left) {
		found = left -> search(name1);
		if (found) {
			return found;
		}
	}

	if (right) {
		found = right -> search(name1);
		if (found) {
			return found;
		}
	}
	return found;
}


BinaryNode* BinaryNode::search(int nid)
{
	int id = getId();
	BinaryNode* found = null;

	if (id == nid) {
		return this;
	}

	if (left) {
		found = left -> search(nid);
		if (found) {
			return found;
		}
	}

	if (right) {
		found = right -> search(nid);
		if (found) {
			return found;
		}
	}
	return found;
}


void BinaryNode::print()
{
	if (name) {
		Printf(">%s %d %d \r\n", name, (int)x, (int)y);
	}
	if (left) {
		left -> print();
	}
	if (right) {
		right -> print();
	}
}
