/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	Button.h
 *
 *****************************************************************************/

// SOL++2000
// 2000.02.18

#ifndef _SOL_PRIMITIVE
#include <sol\Primitive.h>
#endif

#ifndef _SOL_BUTTON
#define _SOL_BUTTON

class Button :public Primitive {
  protected:
	LRESULT	defaultProc(Event& event);
  public:
	Button() :Primitive() { }

	Button(View* parent, HWND hwnd)
		:Primitive(parent, hwnd) { }

	Button(View* parent, const char* label, Args& args);

	virtual Boolean create(View* parent, const char* name, Args& args);

	const char*	defaultCallbackName() { return XmNactivateCallback; }

	void	disable();
	void	enable();
	Arg*	getCallbackTable(int* num);
	
	int		getCheck() {
			return (int)send(BM_GETCHECK, 0, 0L);
	}
	int		getState() {
			return (int)send(BM_GETSTATE, 0, 0L);
	}
	void	setCheck(int check) {
			send(BM_SETCHECK, check, 0L);
	}
	void	setState(int state) {
			send(BM_SETSTATE, state, 0L);
	}
};

#endif

