/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	ComboBox.h
 *
 *****************************************************************************/

// SOL++2000
// 2000/02/18
// 2001/03/19 Added getPreferredSize method.
// 2001/03/29 Added getControlHeight, setControlHeight methods.
// 2001/03/29 Added static variables itemsListDelim, heightMargin.

#ifndef _SOL_PRIMITIVE
#include <sol\Primitive.h>
#endif

#ifndef _SOL_COMBOBOX
#define _SOL_COMBOBOX

class ComboBox :public Primitive {
	static Arg  styles[];
	
	static const char itemsListDelim;
	static const int  heightMargin;
 
 public:
	ComboBox():Primitive() { }
	ComboBox(View* parent, HWND hwnd)
		:Primitive(parent, hwnd) { }

	ComboBox(View* parent, const char* name, Args& args);
	
	virtual Boolean create(View* parent, const char* name, Args& args);

	int 	addString(const char* string) {
			return (int)send(CB_ADDSTRING, 0, (LPARAM)string);
	}
	const char*	defaultCallbackName() { return XmNdefaultActionCallback; }
	int 	deleteString(int indx) {
			return (int)send(CB_DELETESTRING, indx, 0L);
	}
	int		dir(int attr, const char* string) {
			return (int)send(CB_DIR, attr, (LPARAM)string);
	}

	void	findFiles(DWORD attr, const char* pattern);
	void	findFiles(const char* pattern);
	void	findDirectories(const char* dir);

	int		findString(int indx, char* string) {
			return (int)send(CB_FINDSTRING, indx, (LPARAM)string);
	}
	int		findStringExact(int indx, char* string) {
			return (int)send(CB_FINDSTRINGEXACT, indx, (LPARAM)string);
	}
	
	Arg*	getCallbackTable(int* num);
	int 	getCount() {
			return (int)send(CB_GETCOUNT, 0, 0L);
	}
	int		getCurSel() {
			return (int)send(CB_GETCURSEL, 0, 0L);
	}
	int		getDroppedControlRect(RECT* rect) {
			return (int)send(CB_GETDROPPEDCONTROLRECT, 0, (LPARAM)rect);
	}
	int		getDroppedState() {
			return (int)send(CB_GETDROPPEDSTATE, 0, 0L);
	}
	long	getEditSel() {
			return send(CB_GETEDITSEL, 0, 0L);
	}
	int		getExtendedUI() {
			return (int)send(CB_GETEXTENDEDUI, 0, 0L);
	}
	long	getItemData(int indx) {
			return send(CB_GETITEMDATA, indx, 0L);
	}
	int		getItemHeight(int indx) {
			return (int)send(CB_GETITEMHEIGHT, indx, 0L);
	}
    // 2001/03/29
    int     getControlHeight() {
            //Return the height of the edit control(or static-text) portion of the combo box.
			return (int)send(CB_GETITEMHEIGHT, -1, 0L);
	}

	int		getLBText(int indx, char* buffer) {
			return (int)send(CB_GETLBTEXT, indx, (LPARAM)buffer);
	}
	int		getLBTextLen(int indx) {
			return (int)send(CB_GETLBTEXTLEN, indx, 0L);
	}
	void	getValues(Args& args);

	int 	insertString(int indx, char* string) {
			return (int)send(CB_INSERTSTRING, indx, (LPARAM)string);
	}
	int		limitText(int len) {
			return (int)send(CB_LIMITTEXT, len, 0L);
	}
	void	resetContent() {
			send(CB_RESETCONTENT, 0, 0L);
	}
	int		selectString(int indx, char* string) {
			return (int)send(CB_SELECTSTRING, indx, (LPARAM)string);
	}
	int		setCurSel(int indx) {
			return (int)send(CB_SETCURSEL, indx, 0L);
	}
	int		setEditSel(int start, int end) {
			return (int)send(CB_SETEDITSEL, 0, MAKELONG(start, end));
	}
	int		setExtendedUI(int flag) {
			return (int)send(CB_SETEXTENDEDUI, flag, 0L);
	}
	int		setItemData(int indx, LONG data) {
			return (int)send(CB_SETITEMDATA, indx, data);
	}
	int		setItemHeight(int indx, int height) {
			return (int)send(CB_SETITEMHEIGHT, indx, (LPARAM)height);
	}
    int     setControlHeight(int height) {
            return (int)send(CB_SETITEMHEIGHT, -1, (LPARAM)height);
	}

	void	setValues(Args& args);	

	void	showDropDown(int showCmd) {
			send(CB_SHOWDROPDOWN, showCmd, 0L);
	}
	long 	getLocale() {
			return send(CB_GETLOCALE, 0, 0L);
	}
	long 	setLocale(long localeId) {
	 		return send(CB_SETLOCALE, (WPARAM)localeId, 0L);
	}

	// 2001/03/19
    void    getPreferredSize(Dimension& d);

};

#endif
