/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	CommonDialog.cpp
 *
 *****************************************************************************/

// SOL++2000

#include <sol\CommonDialog.h>
#include <sol\Application.h>

CommonDialog* CommonDialog::self = NULL;


CommonDialog::CommonDialog(View* parent, void* data)
	:View(parent) 
{
	calldata = data;
	self     = NULL;
}


Boolean CommonDialog::create(View* parent, void* data)
{ 
	Boolean rc = True;
	View::setParent(parent);


	calldata = data;
	self     = NULL;
	return rc;
}


long CommonDialog::defaultProc(Event& event)
{
	return FALSE;
}


UINT FAR PASCAL CommonDialog::hook(HWND hwnd, UINT message, 
			WPARAM wParam, LPARAM lParam)
{
	if(self) {
		Application::add(hwnd, self);
		self -> setWindow(hwnd);
		self = NULL;
	}
	Event event(message, wParam, lParam);

	CommonDialog* dlg = (CommonDialog*)Application::lookup(hwnd);

	if(dlg == NULL) return FALSE;

	if(message == WM_DESTROY) {
		Application::remove(hwnd);
		return FALSE;
	}
	else 
		return (UINT)dlg -> dispatch(event);
}

	 
void CommonDialog::popup(Action& action)
{
	// Realize a modal/modeless common dialog.
}

