/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	DIBSection.h
 *
 *****************************************************************************/

// SOL++2000

#ifndef _SOL_GDIOBJECT
#include <sol\GdiObject.h>
#endif

#ifndef _SOL_MEMORYDC
#include <sol\MemoryDC.h>
#endif

#ifndef _SOL_DIBSECTION
#define _SOL_DIBSECTION


class DIBSection :public GdiObject {
	MemoryDC	memDC;
	HBITMAP		hbitmap;
	HBITMAP		hprevBitmap;
	unsigned char*	buffer;

	BITMAPINFO*	bi;
	int			bitCount;
	int			bmiSize;

	int			sx;
	int			sy;
	int			ratio;		//Stretching ratio in % unit.
	DWORD		operation;	//Raster operation

	int			colorCount;

	HBITMAP			create(DC& dc);
	unsigned char	getColorIndex(COLORREF color);

	int				getColorCount(int bits);

	int				getColorCount(BITMAPINFOHEADER* bi);

	RGBTRIPLE*		getRGBTriple(int x, int y);

	RGBQUAD*		getRGBQuad(int x, int y);

	WORD			getColor(int x, int y);


public:
	DIBSection();
	
	DIBSection(DC& dc, int width, int height);

	~DIBSection();

	void	clear();

	HBITMAP create(DC& dc, int w, int h);

	void	destroy();
	
	void	draw(HDC hdc, int x, int y);
	
	void	draw(DC& dc, int x, int y);
	
	DC&		getDC() { return memDC; }
	
	int		getWidth();

	int		getHeight();

	HBITMAP	getBitmap() { 
			return hbitmap; 
	}
	

	COLORREF	getPixel(int x, int y); 
	
	BOOL	getPixel(int x, int y, int& r, int& g, int& b);

	void	setPixel(int x, int y, COLORREF color);

	void	setOperation(DWORD op) { operation = op; }
	void	setSource(int x, int y) { sx = x; sy = y; }
	void 	setStretchingRatio(int r) { ratio = r; }

	BOOL	load(DC& dc, const char* filename);

	int		getBitCount() { return bitCount; }
	int		getBmiSize() { return bmiSize; }

	BITMAPINFO* getBitmapInfo() { return bi; }
};

#endif
