/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	Date.h
 *
 *****************************************************************************/

// SOL++2000

#include <sol\Date.h>

int Date::LOCALTIME = 0;
int Date::GMT       = 1;


char* Date::month[] = {
	"Jan",	// 0
	"Feb",	// 1
	"Mar",	// 2
	"Apr",	// 3
	"May",	// 4
	"Jun",	// 5
	"Jul",	// 6
	"Aug",	// 7
	"Sep",	// 8
	"Oct",	// 9
	"Nov",	//10
	"Dec",	//11
};


char* Date::week[] = {
	"Sun",	// 0
	"Mon",	// 1
	"Tue",	// 2
	"Wed",	// 3
	"Thu",	// 4
	"Fri",	// 5
	"Sat",	// 6
};


void Date::buildDate(SYSTEMTIME& sysTime)
{
	systemTime = sysTime;

	char buffer[40];
	if (timeZone == LOCALTIME) {
		sprintf(buffer, "%s, %02d %s %4d %02d:%02d:%02d",
			  week[sysTime.wDayOfWeek],
			sysTime.wDay,
			month[sysTime.wMonth-1],
			 sysTime.wYear,
			 sysTime.wHour,
			sysTime.wMinute,
			sysTime.wSecond);
	} else {
		sprintf(buffer, "%s, %02d %s %4d %02d:%02d:%02d GMT",
			  week[sysTime.wDayOfWeek],
			sysTime.wDay,
			month[sysTime.wMonth-1],
			 sysTime.wYear,
			 sysTime.wHour,
			sysTime.wMinute,
			sysTime.wSecond);
	}
	date = buffer;
}


Date::Date(int zone)
{
	timeZone = zone;
	SYSTEMTIME sysTime;

	if (timeZone == LOCALTIME) {
		GetLocalTime(&sysTime);
	} else {
		GetSystemTime(&sysTime);
	}
	buildDate(sysTime);
}


Date::Date(SYSTEMTIME& sysTime, int zone)
{
	timeZone = zone;
	buildDate(sysTime);
}


//
Date::Date(FILETIME& ft, int zone)
{
	timeZone = zone;
	SYSTEMTIME sysTime;
	FILETIME lt;
	if (timeZone == LOCALTIME) {
		FileTimeToLocalFileTime(&ft, &lt);
		FileTimeToSystemTime(&lt, &sysTime);
	} else {
		FileTimeToSystemTime(&ft, &sysTime);
	}
	buildDate(sysTime);
}
