/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	DC.cpp
 *
 *****************************************************************************/

// SOL++2000
// 2000.6.15 Added a new select method.

#include <sol\DC.h>
#include <sol\GdiObject.h>
#include <sol\Palette.h>
#include <sol\Region.h>
#include <sol\Font.h>


int	DC::getTextHeight() 
{
	SIZE size;
	getTextExtent("A", 1, &size);
	return size.cy;
}

HPALETTE  DC::select(Palette* palette, BOOL background) 
{
	HPALETTE rc = null;
	if (palette)
		rc = ::SelectPalette(hdc, (HPALETTE)palette->get(), background);
	return rc;
}


HFONT  DC::select(Font* font) 
{
	HFONT rc = null;
//	gdiObject -> set(this);
	if (font) {
		rc = (HFONT)::SelectObject(hdc, font->getFont());
	}
	return rc;
}

HGDIOBJ  DC::select(GdiObject* gdiObject) 
{
	HGDIOBJ rc = null;
	if (gdiObject) {
		gdiObject -> set(this);
		rc = ::SelectObject(hdc, gdiObject->get());
	}
	return rc;
}

//<added date="2000.06.15">
HGDIOBJ  DC::select(GdiObject& gdiObject) 
{
	gdiObject.set(this);
	HGDIOBJ rc = ::SelectObject(hdc, gdiObject.get());
	
	return rc;
}
//</added>

int  DC::select(Region* region) 
{
	int rc = 0;
	if (region) {
		region -> set(this);
		rc = ::SelectClipRgn(hdc, (HRGN)region->get());
	}
	return rc;
}

