/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	DialogView.cpp
 *
 *****************************************************************************/


// SOL++2000

#include <sol\DialogView.h>


DialogView::DialogView(View* parent, const char* name, Args& args)
	:PopupView(parent, name, 
		   args.set(XmNexStyle, (ulong)WS_EX_DLGMODALFRAME))
{
	changeSystemMenu();
}


Boolean DialogView::create(View* parent, const char* name, Args& args)
{
	Boolean rc = PopupView::create(parent, name, 
		   args.set(XmNexStyle, (ulong)WS_EX_DLGMODALFRAME));

	changeSystemMenu();

	return rc;
}


void DialogView::changeSystemMenu()
{
	HMENU sysMenu = ::GetSystemMenu(getWindow(), 0);
	int   count   = ::GetMenuItemCount(sysMenu);
	char item1[128];
	char item2[128];
	::GetMenuString(sysMenu, SC_MOVE,  item1, sizeof(item1), MF_BYCOMMAND);
	::GetMenuString(sysMenu, SC_CLOSE, item2, sizeof(item2), MF_BYCOMMAND);

	for(int i = 0; i<count; i++) {
		::DeleteMenu(sysMenu, 0, MF_BYPOSITION);
	}
	::AppendMenu(sysMenu, MF_STRING, SC_MOVE,  item1);
	::AppendMenu(sysMenu, MF_STRING, SC_CLOSE, item2);
}


