/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	Directory.cpp
 *
 *****************************************************************************/

// SOL++2000

#include <sol\Directory.h>


BOOL  Directory::make(const char* name, SECURITY_ATTRIBUTES* attr)
{
	BOOL rc = FALSE;	

	if(name == NULL || *name == Zero) {
		return rc;
	}
	
	char dir[_MAX_PATH];
	strcpy(dir, name);
	char* ptr = dir;

	ptr = strchr(ptr, '\\');

	if(ptr == NULL) {
		rc = ::CreateDirectory(name, attr);
		return rc;
	}

    ptr = dir;
	while(ptr) {
		ptr = strchr(++ptr, '\\');
		if(ptr) { 
			*ptr = NULL;
			rc = ::CreateDirectory(dir, attr);
			*ptr = '\\';
		}
		else {
			rc = ::CreateDirectory(dir, attr);
			break;
		}
	}

	return rc;
}



BOOL Directory::isExistent(const char* dir)
{
	WIN32_FIND_DATA data;

	HANDLE fFile= ::FindFirstFile(dir, &data);
	BOOL rc = FALSE;

	if(fFile != INVALID_HANDLE_VALUE) {
		if(data.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)  {
			rc = TRUE;
		}
		::FindClose(fFile);
	}
	return rc;
}

