/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	DirectoryDialog.h
 *
 *****************************************************************************/

// SOL++2000
// 2000.02.18

#ifndef _SOL_FILEDIALOG
#include <sol\FileDialog.h>
#endif

#ifndef _SOL_DIRECTORYDIALOG
#define _SOL_DIRECTORYDIALOG

class DirectoryDialog :public FileDialog {
	char*	dir;
	long	command(Event& event);
	long	initDialog(Event& event);
	long	dirChanged(Event& event);
	long	driveChanged(Event& event);
	void	setDir(char* string);
  public:
    DirectoryDialog():FileDialog() { }

	DirectoryDialog(View* parent, const char* name, Args& args);
	~DirectoryDialog();
	
	Boolean create(View* parent, const char* name, Args& args);

	char*	getDir() { return dir; }
};

#endif


