/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	DropFiles.h
 *
 *****************************************************************************/

// SOL++2000

#ifndef _SOL_EVENT
#include <sol\Event.h>
#endif
#ifndef _SOL_STRINGLIST
#include <sol\StringList.h>
#endif

#include <shellapi.h>
#include <shlobj.h>

#ifndef _SOL_DROPFILES
#define _SOL_DROPFILES

class DropFiles :public Object {
	BOOL	dropped;
	HDROP	hdrop;
	int		num;
	HDROP	build(StringList* stringList, POINT pt, 
				BOOL ncFlag, BOOL wcFlag);

  public:
	// For dropfile clients.
	DropFiles(HDROP drop);

	// For dropfile servers.
	DropFiles(const char* filename, POINT pt, 
			BOOL ncFlag, BOOL wcFlag = FALSE);
	DropFiles(StringList* stringList, POINT pt, 
			BOOL ncFlag, BOOL wcFlag = FALSE);

	~DropFiles();
	int	 queryCount() {
			return num;
	}
	HDROP 	getDropHandle() {
			return hdrop;
	}
	int	queryFile(int indx, char* fileName, int size);
	int	queryFileNameLength(int indx);

	void 	queryPoint(POINT* pt);
};

#endif

