/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	Event.cpp
 *
 *****************************************************************************/

// SOL++2000

#include <sol\Event.h>

Event::Event(UINT message1, WPARAM wParam1, LPARAM lParam1) 
{
	message = message1;
	wParam  = wParam1;
	lParam  = lParam1;
	result  = NULL;
}


HWND Event::getChild() 
{ 
	if(message == WM_NOTIFY) 
		return ((NMHDR*)lParam)->hwndFrom;
	else 
		return (HWND)lParam; 
}


UINT Event::getControlId() 
{
	if(message == WM_NOTIFY) 
		return ((NMHDR*)lParam)->idFrom;
	else 
		return LOWORD(wParam); 
}


UINT Event::getNotification()
{ 
	if(message == WM_NOTIFY) 
		return ((NMHDR*)lParam)->code;
	else
		return HIWORD(wParam);
}


BOOL Event::isMenuSelected()
{
	BOOL	rc = FALSE;
	
	// if lParam == 0, then menu or accelarator
	if (lParam == 0) {
		if(HIWORD(wParam) == 0) {
			// menu selected;
			rc = TRUE;
		}
	}
	return rc;
}


BOOL Event::fromAccelerator()
{
	BOOL rc = FALSE;
	// if lParam == 0, then menu or accelerator
	if (lParam == 0) {
		if(HIWORD(wParam) == 1) {
			rc = TRUE;
		}
	}
	return rc;
}

