/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	Event.h
 *
 *****************************************************************************/

// SOL++2000

#ifndef _SOL_OBJECT
#include <sol\Object.h>
#endif
#ifndef _SOL_DIMENSION
#include <sol\Dimension.h>
#endif

#ifndef _SOL_EVENT
#define _SOL_EVENT

class Event :public Object {
	UINT 	message;
	WPARAM 	wParam;
	LPARAM 	lParam;
	void*	data;
	long	result;		// result value of event-handler
  public:
	Event(UINT message1, WPARAM wParam1, LPARAM lParam1);

	BOOL	fromAccelerator();
	HWND 	getChild();
	UINT    getControlId();
	UINT	getNotification();
	BOOL	isMenuSelected();

	WPARAM 	getMenuId() { return LOWORD(wParam); }

	UINT 	getMessage() { return message; }
	WPARAM 	getWParam() { return wParam; }
	LPARAM 	getLParam() { return lParam; }
	void*	getData()      { return data; }

	void 	getMousePosition(int& x, int& y) {
			x = LOWORD(lParam);
			y = HIWORD(lParam);
	}
	void 	getMousePosition(POINT* pt) {
			pt->x = LOWORD(lParam);
			pt->y = HIWORD(lParam);
	}

	void	getSize(int& w, int& h) {
			w = LOWORD(lParam);
			h = HIWORD(lParam);
	}
	void	getSize(Dimension& d) {
			d.set(LOWORD(lParam), HIWORD(lParam));
	}

	void	setData(void* data1)  { data = data1; }

	long	getResult() { return result; }
	void	setResult(long val) { result = val; }
};

#endif

