/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	File.h
 *
 *****************************************************************************/

// SOL++2000
// 1999.08.06 Modified the type of argument for get*Time methods
// to take a reference to FILETIME, not a pointer to FILETIME.
// 1999.08.10 Added a shareMode argument to openReadOnly method.

// 2000.07.09 Modified datatype for read/write methods.

#include <io.h>
#ifndef _SOL_OBJECT
#include <sol\Object.h>
#endif

#ifndef _SOL_FILE
#define _SOL_FILE

class File :public Object {
	UINT	mode;	
	HANDLE  fh;
	OFSTRUCT ofs;
	// 1999.03.09
  protected:
	  File(HANDLE handle) {
		  fh = handle;
	}
  public:
	File();
	~File();
	BOOL 	create(const char* name);

	BOOL	create(const char* name, 
				DWORD access, DWORD share,
    			SECURITY_ATTRIBUTES*  securityAttrs, 
    			DWORD  howToCreate,	
    			DWORD  attrsAndFlags, 
    			HANDLE  hTemplateFile); 				
	virtual void close();
	long 	fileLength();
	virtual void flush();
	DWORD	getAttributes(const char* name) {
			return ::GetFileAttributes(name);
	}

	HANDLE	getHandle() { return fh; }
	BOOL	getFileInformation(BY_HANDLE_FILE_INFORMATION* info) {
			return ::GetFileInformationByHandle(fh, info);
	}
	DWORD	getType() { return ::GetFileType(fh); }
	
	BOOL	getCreationTime(FILETIME& creation);

	BOOL	getLastAccessTime(FILETIME& lastAccess);

	BOOL	getLastWriteTime(FILETIME& lastWrite);

	BOOL	getTime(FILETIME& creation, 
			FILETIME& lastAccess, FILETIME& lastWrite) {
			return ::GetFileTime(fh, &creation, &lastAccess, &lastWrite);
	}
	
	BOOL	isExistent(const char* name);
	
	BOOL  	openReadOnly(const char* name, int shareMode = 0);
	BOOL  	openReadWrite(const char* name);
	BOOL 	openWriteOnly(const char* name);
	BOOL  	remove(const char* name);
	long 	seek(long pos, int dir);

	unsigned long	read(char* buffer, unsigned long size);
	unsigned long  	write(char* buffer, unsigned long size);

	UINT 	getMode() { return mode; }
	BOOL	setTime(const FILETIME* creation, 
				const FILETIME* lastAccess, const FILETIME* lastWrite) {
			return ::SetFileTime(fh, creation, lastAccess, lastWrite);
	}
	void	setEnd() {
			::SetEndOfFile(fh);
	}
};

#endif

