/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	FileListBox.cpp
 *
 *****************************************************************************/

// SOL++2000

#include <sol\FileListBox.h>
#include <sol\Directory.h>


FileListBox::FileListBox(View* parent, const char* label, Args& args)
	:ListBox(parent, label, 
		args.set(XmNstyle, (ulong)LBS_STANDARD))
{
	directory = new char[_MAX_PATH];
	fileSpec  = new char[_MAX_FNAME];

	// Setting default values.
	Directory dir;
	dir.getCwd(directory, _MAX_PATH);
	strcpy(fileSpec, "*.*");

	attribute = FILE_ATTRIBUTE_ARCHIVE|
		FILE_ATTRIBUTE_DIRECTORY|
		FILE_ATTRIBUTE_HIDDEN| 	
		FILE_ATTRIBUTE_NORMAL|	
		FILE_ATTRIBUTE_READONLY| 
		FILE_ATTRIBUTE_SYSTEM;
}


FileListBox::~FileListBox()
{
	delete [] directory;
	delete [] fileSpec;
}



Boolean FileListBox::create(View* parent, const char* label, Args& args)
{
	Boolean rc = ListBox::create(parent, label, 
		args.set(XmNstyle, (ulong)LBS_STANDARD));

	directory = new char[_MAX_PATH];
	fileSpec  = new char[_MAX_FNAME];

	// Setting default values.
	Directory dir;
	dir.getCwd(directory, _MAX_PATH);
	strcpy(fileSpec, "*.*");

	attribute = FILE_ATTRIBUTE_ARCHIVE|
		FILE_ATTRIBUTE_DIRECTORY|
		FILE_ATTRIBUTE_HIDDEN| 	
		FILE_ATTRIBUTE_NORMAL|	
		FILE_ATTRIBUTE_READONLY| 
		FILE_ATTRIBUTE_SYSTEM;

	return rc;
}



void FileListBox::setup(const char* dir, const char* spec, int attr)
{
   	char pathspec[_MAX_PATH];

	setDirectory(dir);
	setFileSpec(spec);
	setAttribute(attr);

	if(dir[strlen(dir)-1] == '\\') {
		sprintf(pathspec, "%s%s", dir, fileSpec);
	}
	else {
		sprintf(pathspec, "%s\\%s", dir, fileSpec);
	}
	findFiles(attribute, pathspec);
}


void FileListBox::setFileSpec(const char* string)
{
	strcpy(fileSpec, string);
}


void FileListBox::update()
{
   	char pathspec[_MAX_PATH];
	sprintf(pathspec, "%s\\%s", directory, fileSpec);

	resetContent();

	findFiles(attribute, pathspec);
}


// Give a char array for fileName.
// For example:char fileName[_MAX_PATH];
void FileListBox::getFileName(char* fileName)
{
	strcpy(fileName, "");
	int indx = getCurSel();
	if(indx != LB_ERR) {
		getText(indx, fileName);
	}
}

// Give a char array for pathName.
// For example:char pathName[_MAX_PATH];
void FileListBox::getPathName(char* pathName)
{
	char name[_MAX_PATH];
	strcpy(name, "");
	int indx = getCurSel();
	if(indx != LB_ERR) {
		getText(indx, name);
	}
	sprintf(pathName, "%s\\%s", directory, name);
}


char* FileListBox::getPathName()
{
	int indx = getCurSel();
	char* pathName = NULL;
	if(indx != LB_ERR) {
		int len = getTextLen(indx);
		char* item = new char[len+1];
		getText(indx, item);
		pathName = new char[strlen(directory)+strlen(item)+2];
		sprintf(pathName, "%s\\%s", directory, item); 		
		delete [] item;
	}
	return pathName;
}

