/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	FileListBox.h
 *
 *****************************************************************************/

// SOL++2000
// 2000.02.18

#ifndef _SOL_LISTBOX
#include <sol\ListBox.h>
#endif

#ifndef _SOL_FILELISTBOX
#define _SOL_FILELISTBOX

class FileListBox :public ListBox {
	char*	directory;
	char*	fileSpec;
	long	attribute;

  public:
	FileListBox(): ListBox() { }
	FileListBox(View* parent, const char* label, Args& args);
	~FileListBox();

	virtual Boolean create(View* parent, const char* label, Args& args);

	void 	getDirectory(char* dir) {
			strcpy(dir, directory);
	}
	void 	getFileName(char* fileName);

	void 	getFileSpec(char* spec) {
			strcpy(spec, fileSpec);
	}
	void	getPathName(char* pathName);
	char*	getPathName();
	void 	setAttribute(long  attr) {
			attribute = attr;
	}
	void 	setDirectory(const char*  dir) {
			strcpy(directory, dir);
	}
	void 	setFileSpec(const char*  spec);
	void 	setup(const char* dir, const char* spec, int attr);
	void 	update();
};

#endif
