/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	FolderTreeDialog.cpp
 *
 *****************************************************************************/

// SOL++2000


#include <sol\FolderTreeDialog.h>
#include <sol\ClientDC.h>


FolderTreeDialog::FolderTreeDialog(View* parent, 
						const char* name, Args& args)
		:DynamicDialog(parent, name,
			args.set(XmNstyle, (ulong)WS_THICKFRAME)
			    .set(XmNbackground, (COLOR_BTNFACE+1))),

	initialized(FALSE)
{
	Args ar;
	ar.reset();
	ar.set(XmNheight, -12);
//	ar.set(XmNcharSet, (ulong)SHIFTJIS_CHARSET);
//	ar.set(XmNfaceName, "lr ");
	font.create(ar);

	ar.reset();
	label.create(this, "Folder", ar);
	label.setFont(&font);

	ar.reset();
	textf.create(this, "", ar);
	textf.limitText(_MAX_PATH);
    textf.setFont(&font);
    ClientDC cdc(&textf);

	HFONT pfont = cdc.select(&font);
    th = cdc.getTextHeight();

	SIZE size;
	char* string = " OK ";
	cdc.getTextExtent(string, strlen(string), &size);						
	cdc.select(pfont);

	bwidth = size.cx+ size.cy*2;

	ar.reset();
	ar.set(XmNexStyle, (ulong)WS_EX_CLIENTEDGE);
	ar.set(XmNstyle, (ulong)TVS_HASBUTTONS|TVS_HASLINES|TVS_LINESATROOT);
	treev.create(this, "", ar);

	// 
	treev.addCallback(XmNitemExpandingCallback, this,
				(Callback)&FolderTreeDialog::expanding, NULL);

	treev.addCallback(XmNselChangingCallback, this,
		(Callback)&FolderTreeDialog::selChanging, NULL);

	ar.reset();
	ar.set(XmNid, IDOK);
	ok.create(this, " OK ", ar);
	ok.setFont(&font);

	ar.reset();
	ar.set(XmNid, IDCANCEL);
	cancel.create(this, "Cancel", ar);
	cancel.setFont(&font);
	cancel.addCallback(XmNactivateCallback, this,
		(Callback)&PopupView::popdown, NULL);
	
	addEventHandler(WM_SIZE, this,
		(Handler)&FolderTreeDialog::size, NULL);

	resize();
}


FolderTreeDialog::~FolderTreeDialog() 
{ 
/*
	delete label;
	delete textf;
	delete ok;
	delete cancel;

	delete treev; 
	delete font;
	*/
}



Boolean FolderTreeDialog::create(View* parent, 
						const char* name, Args& args)

{
	Boolean rc = DynamicDialog::create(parent, name,
			args.set(XmNstyle, (ulong)WS_THICKFRAME)
			    .set(XmNbackground, (COLOR_BTNFACE+1)));

	initialized = FALSE;
	Args ar;
	ar.reset();
	ar.set(XmNheight, -12);
//	ar.set(XmNcharSet, (ulong)SHIFTJIS_CHARSET);
//	ar.set(XmNfaceName, "lr ");
	font.create(ar);

	ar.reset();
	label.create(this, "Folder", ar);
	label.setFont(&font);

	ar.reset();
	textf.create(this, "", ar);
	textf.limitText(_MAX_PATH);
    textf.setFont(&font);

    ClientDC cdc(&textf);

	HFONT pfont = cdc.select(&font);
    th = cdc.getTextHeight();

	SIZE size;
	char* string = " OK ";
	cdc.getTextExtent(string, strlen(string), &size);						
	cdc.select(pfont);

	bwidth = size.cx+ size.cy*2;

	ar.reset();
	ar.set(XmNexStyle, (ulong)WS_EX_CLIENTEDGE);
	ar.set(XmNstyle, (ulong)TVS_HASBUTTONS|TVS_HASLINES|TVS_LINESATROOT);
	treev.create(this, "", ar);

	// 
	treev.addCallback(XmNitemExpandingCallback, this,
				(Callback)&FolderTreeDialog::expanding, NULL);

	treev.addCallback(XmNselChangingCallback, this,
		(Callback)&FolderTreeDialog::selChanging, NULL);

	ar.reset();
	ar.set(XmNid, IDOK);
	ok.create(this, " OK ", ar);
	ok.setFont(&font);

	ar.reset();
	ar.set(XmNid, IDCANCEL);
	cancel.create(this, "Cancel", ar);
	cancel.setFont(&font);
	cancel.addCallback(XmNactivateCallback, this,
		(Callback)&PopupView::popdown, NULL);
	
	addEventHandler(WM_SIZE, this,
		(Handler)&FolderTreeDialog::size, NULL);

	resize();

	return rc;
}


int  FolderTreeDialog::getFolder(char* buffer, int len) 
{
	int rc = 0;
	rc = textf.getText(buffer, len);
	return rc;
}


void FolderTreeDialog::setFolder(const char* name)
{
	textf.setText(name);
}


void FolderTreeDialog::popup(Action& action)
{
	if(initialized == FALSE) {
		capture();
		::SetCursor(::LoadCursor(NULL, IDC_WAIT));
		treev.buildDirTree();
		::SetCursor(::LoadCursor(NULL, IDC_ARROW));
		::ReleaseCapture();

		initialized = TRUE;
	}
	disableOwner();

	raise();
	show(SW_NORMAL);
}


long FolderTreeDialog::size(Event& event)
{
	LPARAM s = event.getLParam();
		
	int w = LOWORD(s);
	int h = HIWORD(s);

	label.reshape(0, 2,  w, th);
	textf.reshape(0, 2+th, w, th+8); 
	treev.reshape(0, th+th+10, w, h-th-th-10-th-20);

	ok.reshape(w-bwidth*2-20, h - th-16, bwidth, th+12);
	cancel.reshape(w-bwidth-10, h - th-16, bwidth, th+12);
    
	return 0;
}


void FolderTreeDialog::expanding(Action& action)
{							 
	Event& event = action.getEvent();	
	NM_TREEVIEW* nmtreev = (NM_TREEVIEW*)event.getLParam();
	HTREEITEM htreeItem = nmtreev->itemNew.hItem;
	char dir[_MAX_PATH];
	dir[0] = Zero;
	// Iꂽm[h̃fBNg̃tpX𓾂
	treev.getHierachy(htreeItem, dir, "\\");
	// TufBNg̃c[
	treev.findDirectories(htreeItem, dir, 0, 2);
	treev.sortChildren(htreeItem, TRUE);
}


void FolderTreeDialog::selChanging(Action& action)
{							 
	Event& event = action.getEvent();	
	NM_TREEVIEW* nmtreev = (NM_TREEVIEW*)event.getLParam();
	HTREEITEM htreeItem = nmtreev->itemNew.hItem;
	char dir[_MAX_PATH];
	dir[0] = Zero;
	// Iꂽm[h̃fBNg̃tpX𓾂
	treev.getHierachy(htreeItem, dir, "\\");
	textf.setText(dir);
}

void FolderTreeDialog::addOkCallback(Object* object,
							Callback callback)
{
	ok.addCallback(XmNactivateCallback, object,
				callback, NULL);
}

