/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	Gadget.h
 *
 *****************************************************************************/

// SOL++2000
// 2000.02.18


#ifndef _SOL_VIEW
#include <sol\View.h>
#endif
#ifndef _SOL_DC
#include <sol\DC.h>
#endif

#ifndef _SOL_LAYOUTABLE
#include <sol\Layoutable.h>
#endif

#ifndef _SOL_GADGET
#define _SOL_GADGET

class Gadget :public Object, public Layoutable {
	int	x;
	int	y;
	int	width;
	int	height;
	View*	parent;
  public:
	Gadget() { }
  	Gadget(View* view, const char* label, Args& args);
	~Gadget();
	
	virtual Boolean create(View* view, const char* label, Args& args);

	void	reshape(int x, int y, int width, int height);
	virtual void draw(DC* dc);
	virtual void draw(DC* dc, int x, int y);

	View*	getParent() { return parent; }
	void	getRect(RECT* r);
	virtual void layout(int x, int y, int w, int h);

	void	setRect(RECT* r);
	void	getLocation(int& x1, int& y1) {
			x1 = x;
			y1 = y;
	}
	void	getSize(int& w, int& h) { 
			w = width; 
			h = height;
	}
	void	setLocation(int x1, int y1) {
			x = x1;
			y = y1;
	}
	void	setSize(int w, int h) { 
			width = w; 
			height = h;
	}
};

#endif
