/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	HandlerList.cpp
 *
 *****************************************************************************/

// SOL++2000

#include <sol\HandlerList.h>


HandlerList::~HandlerList()
{
	HandlerEntry* ptr = entry;
	HandlerEntry* prev;
	while(ptr) {
		prev = ptr;
		ptr  = ptr -> getNext();
		delete prev;
	}
}


void HandlerList::add(UINT msg, Object* object, Handler proc, void* data)
{
	HandlerEntry* ent = new HandlerEntry(msg, object, proc, data);
	ent -> add(entry);
	entry = ent;
}


Boolean HandlerList::call(Event& event, ulong* value) 
{
	WORD msg = event.getMessage();
	HandlerEntry* ptr = entry;
	while(ptr) {
		if(msg == ptr->getMessage()) {
			*value = ptr -> call(event);
			return TRUE;
		}
		ptr = ptr -> getNext();
	}
	return FALSE;
}

void HandlerList::clear()
{
	HandlerEntry* ptr = entry;
	HandlerEntry* prev = entry;

	while(ptr) {
		prev = ptr;
		ptr = ptr -> getNext();
		delete prev;
	}
	entry = null;
}
