/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	Icon.h
 *
 *****************************************************************************/

// SOL++2000

#ifndef _SOL_RESOURCE
#include <sol\Resource.h>
#endif

#ifndef _SOL_ICON
#define _SOL_ICON

class Icon :public Resource {
	int x;
	int y;
	int width;
	int height;
	BOOL destructable;
  public:
	Icon(const char* name, HICON hicon);
	~Icon() { 
		if(destructable) {
			::DestroyIcon((HICON)get());
		}
	}

	BOOL	getIconInfo(ICONINFO* info) {
		return ::GetIconInfo((HICON)get(), info);
	}
	void	move(int x1, int y1) {
		x = x1;	
		y = y1;
	}

	void	draw(HDC hdc, int x1, int y1);

	void	draw(HDC hdc, int x1, int y1, int cx, int cy,
			UINT index, HBRUSH hbrSrc, UINT flags);

	void	setFlag(int flag) { destructable = flag; }
	void	getSize(int* w, int* h) {
			*w = width; *h = height;
	}
};

#endif

